/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class CastLongToDate
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int inputColumn;
    private int outputColumn;
    private transient Date date = new Date(0L);

    public CastLongToDate() {
    }

    public CastLongToDate(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inV = (LongColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        if (n == 0) {
            return;
        }
        switch (this.inputTypes[0]) {
            case TIMESTAMP: {
                if (inV.noNulls) {
                    outV.noNulls = true;
                    if (inV.isRepeating) {
                        outV.isRepeating = true;
                        this.date.setTime(inV.vector[0] / 1000000L);
                        outV.vector[0] = DateWritable.dateToDays((Date)this.date);
                        break;
                    }
                    if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            this.date.setTime(inV.vector[i] / 1000000L);
                            outV.vector[i] = DateWritable.dateToDays((Date)this.date);
                        }
                        outV.isRepeating = false;
                        break;
                    }
                    for (int i = 0; i != n; ++i) {
                        this.date.setTime(inV.vector[i] / 1000000L);
                        outV.vector[i] = DateWritable.dateToDays((Date)this.date);
                    }
                    outV.isRepeating = false;
                    break;
                }
                outV.noNulls = false;
                if (inV.isRepeating) {
                    outV.isRepeating = true;
                    outV.isNull[0] = inV.isNull[0];
                    if (inV.isNull[0]) break;
                    this.date.setTime(inV.vector[0] / 1000000L);
                    outV.vector[0] = DateWritable.dateToDays((Date)this.date);
                    break;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outV.isNull[i] = inV.isNull[i];
                        if (inV.isNull[i]) continue;
                        this.date.setTime(inV.vector[i] / 1000000L);
                        outV.vector[i] = DateWritable.dateToDays((Date)this.date);
                    }
                    outV.isRepeating = false;
                    break;
                }
                System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inV.isNull[i]) continue;
                    this.date.setTime(inV.vector[i] / 1000000L);
                    outV.vector[i] = DateWritable.dateToDays((Date)this.date);
                }
                outV.isRepeating = false;
                break;
            }
            case DATE: {
                inV.copySelected(batch.selectedInUse, batch.selected, batch.size, outV);
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public String getOutputType() {
        return "date";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.LONG).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

