/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.UnsignedInt128;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.udf.generic.RoundUtils;

public class DecimalUtil {
    public static final Decimal128 DECIMAL_ONE = new Decimal128();
    private static final UnsignedInt128 scratchUInt128 = new UnsignedInt128();

    public static void addChecked(int i, Decimal128 left, Decimal128 right, DecimalColumnVector outputColVector) {
        try {
            Decimal128.add((Decimal128)left, (Decimal128)right, (Decimal128)outputColVector.vector[i], (short)outputColVector.scale);
            outputColVector.vector[i].checkPrecisionOverflow((int)outputColVector.precision);
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void subtractChecked(int i, Decimal128 left, Decimal128 right, DecimalColumnVector outputColVector) {
        try {
            Decimal128.subtract((Decimal128)left, (Decimal128)right, (Decimal128)outputColVector.vector[i], (short)outputColVector.scale);
            outputColVector.vector[i].checkPrecisionOverflow((int)outputColVector.precision);
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void multiplyChecked(int i, Decimal128 left, Decimal128 right, DecimalColumnVector outputColVector) {
        try {
            Decimal128.multiply((Decimal128)left, (Decimal128)right, (Decimal128)outputColVector.vector[i], (short)outputColVector.scale);
            outputColVector.vector[i].checkPrecisionOverflow((int)outputColVector.precision);
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void divideChecked(int i, Decimal128 left, Decimal128 right, DecimalColumnVector outputColVector) {
        try {
            Decimal128.divide((Decimal128)left, (Decimal128)right, (Decimal128)outputColVector.vector[i], (short)outputColVector.scale);
            outputColVector.vector[i].checkPrecisionOverflow((int)outputColVector.precision);
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void moduloChecked(int i, Decimal128 left, Decimal128 right, DecimalColumnVector outputColVector) {
        try {
            Decimal128.modulo((Decimal128)left, (Decimal128)right, (Decimal128)outputColVector.vector[i], (short)outputColVector.scale);
            outputColVector.vector[i].checkPrecisionOverflow((int)outputColVector.precision);
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void floor(int i, Decimal128 input, DecimalColumnVector outputColVector) {
        try {
            Decimal128 result = outputColVector.vector[i];
            result.update(input);
            result.zeroFractionPart(scratchUInt128);
            result.changeScaleDestructive(outputColVector.scale);
            if (result.compareTo(input) != 0 && input.getSignum() < 0) {
                result.subtractDestructive(DECIMAL_ONE, outputColVector.scale);
            }
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void ceiling(int i, Decimal128 input, DecimalColumnVector outputColVector) {
        try {
            Decimal128 result = outputColVector.vector[i];
            result.update(input);
            result.zeroFractionPart(scratchUInt128);
            result.changeScaleDestructive(outputColVector.scale);
            if (result.compareTo(input) != 0 && input.getSignum() > 0) {
                result.addDestructive(DECIMAL_ONE, outputColVector.scale);
            }
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void round(int i, Decimal128 input, DecimalColumnVector outputColVector) {
        HiveDecimal inputHD = HiveDecimal.create((BigDecimal)input.toBigDecimal());
        HiveDecimal result = RoundUtils.round(inputHD, (int)outputColVector.scale);
        if (result == null) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        } else {
            outputColVector.vector[i].update(result.bigDecimalValue().toPlainString(), outputColVector.scale);
        }
    }

    public static void sign(int i, Decimal128 input, LongColumnVector outputColVector) {
        outputColVector.vector[i] = input.getSignum();
    }

    public static void abs(int i, Decimal128 input, DecimalColumnVector outputColVector) {
        Decimal128 result = outputColVector.vector[i];
        try {
            result.update(input);
            result.absDestructive();
            result.changeScaleDestructive(outputColVector.scale);
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    public static void negate(int i, Decimal128 input, DecimalColumnVector outputColVector) {
        Decimal128 result = outputColVector.vector[i];
        try {
            result.update(input);
            result.negateDestructive();
            result.changeScaleDestructive(outputColVector.scale);
        }
        catch (ArithmeticException e) {
            outputColVector.noNulls = false;
            outputColVector.isNull[i] = true;
        }
    }

    static {
        DECIMAL_ONE.update(1L, (short)0);
    }
}

