/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetDoubleArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncDoubleToDouble;

public class FuncLogWithBaseDoubleToDouble
extends MathFuncDoubleToDouble
implements ISetDoubleArg {
    private static final long serialVersionUID = 1L;
    private double base;

    public FuncLogWithBaseDoubleToDouble(double scalarVal, int colNum, int outputColumn) {
        super(colNum, outputColumn);
        this.base = scalarVal;
    }

    public FuncLogWithBaseDoubleToDouble() {
    }

    @Override
    protected double func(double d) {
        return Math.log(d) / Math.log(this.base);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
    }

    @Override
    public void setArg(double d) {
        this.base = d;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DOUBLE, VectorExpressionDescriptor.ArgumentType.DOUBLE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

