/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class LongToStringUnaryUDF
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    int inputColumn;
    int outputColumn;

    public LongToStringUnaryUDF(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    public LongToStringUnaryUDF() {
    }

    protected abstract void func(BytesColumnVector var1, long[] var2, int var3);

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        outV.initBuffer();
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            outV.noNulls = true;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                this.func(outV, vector, 0);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.func(outV, vector, i);
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    this.func(outV, vector, i);
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = inputColVector.isNull[0];
                if (!inputColVector.isNull[0]) {
                    this.func(outV, vector, 0);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inputColVector.isNull[i];
                    if (inputColVector.isNull[i]) continue;
                    this.func(outV, vector, i);
                }
                outV.isRepeating = false;
            } else {
                System.arraycopy(inputColVector.isNull, 0, outV.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.isNull[i]) continue;
                    this.func(outV, vector, i);
                }
                outV.isRepeating = false;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public String getOutputType() {
        return "String";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.LONG).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

