/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.LongWritable;
import org.apache.hive.common.util.Decimal128FastBuffer;

@Description(name="avg", value="_FUNC_(AVG) - Returns the average value of expr (vectorized, type: decimal)")
public class VectorUDAFAvgDecimal
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient Object[] partialResult;
    private transient LongWritable resultCount;
    private transient HiveDecimalWritable resultSum;
    private transient StructObjectInspector soi;
    private final transient Decimal128FastBuffer scratch;
    private short sumScale;
    private short sumPrecision;
    private short inputScale;
    private short inputPrecision;
    private transient Decimal128 scratchDecimal = new Decimal128();

    public VectorUDAFAvgDecimal(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFAvgDecimal() {
        this.partialResult = new Object[2];
        this.resultCount = new LongWritable();
        this.resultSum = new HiveDecimalWritable();
        this.partialResult[0] = this.resultCount;
        this.partialResult[1] = this.resultSum;
        this.scratch = new Decimal128FastBuffer();
    }

    private void initPartialResultInspector() {
        DecimalTypeInfo dtiSum = GenericUDAFAverage.deriveSumFieldTypeInfo(this.inputPrecision, this.inputScale);
        this.sumScale = (short)dtiSum.scale();
        this.sumPrecision = (short)dtiSum.precision();
        ArrayList<Object> foi = new ArrayList<Object>();
        foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        foi.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)dtiSum));
        ArrayList<String> fname = new ArrayList<String>();
        fname.add("count");
        fname.add("sum");
        this.soi = ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(bufferIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        Decimal128[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, vector[0], batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, vector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, Decimal128 value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValueWithCheck(value, this.sumScale);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, Decimal128[] values, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValueWithCheck(values[selection[i]], this.sumScale);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, Decimal128[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValueWithCheck(values[i], this.sumScale);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, Decimal128 value, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[selection[i]]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValueWithCheck(value, this.sumScale);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, Decimal128 value, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValueWithCheck(value, this.sumScale);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, Decimal128[] values, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, j);
            myagg.sumValueWithCheck(values[i], this.sumScale);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, Decimal128[] values, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.sumValueWithCheck(values[i], this.sumScale);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        Decimal128[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls) {
                if (myagg.isNull) {
                    myagg.isNull = false;
                    myagg.sum.zeroClear();
                    myagg.count = 0L;
                }
                this.scratchDecimal.update((long)batchSize);
                this.scratchDecimal.multiplyDestructive(vector[0], vector[0].getScale());
                myagg.sum.update(this.scratchDecimal);
                myagg.count += batchSize;
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, Decimal128[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            Decimal128 value = vector[i];
            myagg.sumValueWithCheck(value, this.sumScale);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, Decimal128[] vector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.sum.zeroClear();
            myagg.count = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            Decimal128 value = vector[selected[i]];
            myagg.sumValueNoCheck(value, this.sumScale);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, Decimal128[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Decimal128 value = vector[i];
            myagg.sumValueWithCheck(value, this.sumScale);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, Decimal128[] vector, int batchSize) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.sum.zeroClear();
            myagg.count = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            Decimal128 value = vector[i];
            myagg.sumValueNoCheck(value, this.sumScale);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        assert (0L < myagg.count);
        this.resultCount.set(myagg.count);
        this.resultSum.set(HiveDecimal.create((BigDecimal)myagg.sum.toBigDecimal()));
        return this.partialResult;
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return this.soi;
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.primitive2() * 2, model.memoryAlign());
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
        ExprNodeDesc inputExpr = desc.getParameters().get(0);
        DecimalTypeInfo tiInput = (DecimalTypeInfo)inputExpr.getTypeInfo();
        this.inputScale = (short)tiInput.scale();
        this.inputPrecision = (short)tiInput.precision();
        this.initPartialResultInspector();
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private final transient Decimal128 sum = new Decimal128();
        private transient long count;
        private transient boolean isNull;

        Aggregation() {
        }

        public void sumValueWithCheck(Decimal128 value, short scale) {
            if (this.isNull) {
                this.sum.update(value);
                this.sum.changeScaleDestructive(scale);
                this.count = 1L;
                this.isNull = false;
            } else {
                this.sum.addDestructive(value, scale);
                ++this.count;
            }
        }

        public void sumValueNoCheck(Decimal128 value, short scale) {
            this.sum.addDestructive(value, scale);
            ++this.count;
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum.zeroClear();
            this.count = 0L;
        }
    }
}

