/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="min", value="_FUNC_(expr) - Returns the minimum value of expr (vectorized, type: string)")
public class VectorUDAFMinString
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient Text result = new Text();

    public VectorUDAFMinString(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFMinString() {
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregrateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        BytesColumnVector inputColumn = (BytesColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        if (inputColumn.noNulls) {
            if (inputColumn.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColumn, batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColumn, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColumn, batchSize);
            }
        } else if (!inputColumn.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColumn, batchSize, batch.selected);
            } else {
                this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, inputColumn, batchSize);
            }
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, BytesColumnVector inputColumn, int batchSize) {
        byte[] bytes = inputColumn.vector[0];
        int start = inputColumn.start[0];
        int length = inputColumn.length[0];
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(bytes, start, length);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, BytesColumnVector inputColumn, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColumn.vector[row], inputColumn.start[row], inputColumn.length[row]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, BytesColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, BytesColumnVector inputColumn, int batchSize, int[] selection) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            if (inputColumn.isNull[row]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColumn.vector[row], inputColumn.start[row], inputColumn.length[row]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, BytesColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        BytesColumnVector inputColumn = (BytesColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColumn.isRepeating) {
            if (inputColumn.noNulls) {
                myagg.checkValue(inputColumn.vector[0], inputColumn.start[0], inputColumn.length[0]);
            }
            return;
        }
        if (!batch.selectedInUse && inputColumn.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputColumn, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputColumn, batchSize);
        } else if (inputColumn.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputColumn, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputColumn, batchSize, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, BytesColumnVector inputColumn, int batchSize, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (inputColumn.isNull[i]) continue;
            myagg.checkValue(inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, BytesColumnVector inputColumn, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            myagg.checkValue(inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, BytesColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            myagg.checkValue(inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, BytesColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            myagg.checkValue(inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        this.result.set(myagg.bytes, 0, myagg.length);
        return this.result;
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp(model.object() + model.ref() + model.primitive1() * 2, model.memoryAlign());
    }

    @Override
    public boolean hasVariableSize() {
        return true;
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private static final transient int MIN_BUFFER_SIZE = 16;
        private transient byte[] bytes = new byte[16];
        private transient int length;
        private transient boolean isNull = true;

        private Aggregation() {
        }

        public void checkValue(byte[] bytes, int start, int length) {
            if (this.isNull) {
                this.isNull = false;
                this.assign(bytes, start, length);
            } else if (StringExpr.compare(bytes, start, length, this.bytes, 0, this.length) < 0) {
                this.assign(bytes, start, length);
            }
        }

        public void assign(byte[] bytes, int start, int length) {
            if (this.bytes.length < length) {
                this.bytes = new byte[length];
            }
            System.arraycopy(bytes, start, this.bytes, 0, length);
            this.length = length;
        }

        @Override
        public int getVariableSize() {
            JavaDataModel model = JavaDataModel.get();
            return model.lengthForByteArrayOfSize(this.bytes.length);
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.length = 0;
        }
    }
}

