/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;

public class RecordIdentifier
implements WritableComparable<RecordIdentifier> {
    private long transactionId;
    private int bucketId;
    private long rowId;

    public RecordIdentifier() {
    }

    public RecordIdentifier(long transactionId, int bucket, long rowId) {
        this.transactionId = transactionId;
        this.bucketId = bucket;
        this.rowId = rowId;
    }

    public void setValues(long transactionId, int bucketId, long rowId) {
        this.transactionId = transactionId;
        this.bucketId = bucketId;
        this.rowId = rowId;
    }

    public void set(RecordIdentifier other) {
        this.transactionId = other.transactionId;
        this.bucketId = other.bucketId;
        this.rowId = other.rowId;
    }

    public void setRowId(long rowId) {
        this.rowId = rowId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public long getRowId() {
        return this.rowId;
    }

    protected int compareToInternal(RecordIdentifier other) {
        if (other == null) {
            return -1;
        }
        if (this.transactionId != other.transactionId) {
            return this.transactionId < other.transactionId ? -1 : 1;
        }
        if (this.bucketId != other.bucketId) {
            return this.bucketId < other.bucketId ? -1 : 1;
        }
        if (this.rowId != other.rowId) {
            return this.rowId < other.rowId ? -1 : 1;
        }
        return 0;
    }

    public int compareTo(RecordIdentifier other) {
        if (other.getClass() != RecordIdentifier.class) {
            return -other.compareTo(this);
        }
        return this.compareToInternal(other);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.transactionId);
        dataOutput.writeInt(this.bucketId);
        dataOutput.writeLong(this.rowId);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.transactionId = dataInput.readLong();
        this.bucketId = dataInput.readInt();
        this.rowId = dataInput.readLong();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        RecordIdentifier oth = (RecordIdentifier)other;
        return oth.transactionId == this.transactionId && oth.bucketId == this.bucketId && oth.rowId == this.rowId;
    }

    public String toString() {
        return "{originalTxn: " + this.transactionId + ", bucket: " + this.bucketId + ", row: " + this.getRowId() + "}";
    }
}

