/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.MemoryManager;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public final class OrcFile {
    public static final String MAGIC = "ORC";
    @Deprecated
    public static final String COMPRESSION = "orc.compress";
    @Deprecated
    public static final String COMPRESSION_BLOCK_SIZE = "orc.compress.size";
    @Deprecated
    public static final String STRIPE_SIZE = "orc.stripe.size";
    @Deprecated
    public static final String ROW_INDEX_STRIDE = "orc.row.index.stride";
    @Deprecated
    public static final String ENABLE_INDEXES = "orc.create.index";
    @Deprecated
    public static final String BLOCK_PADDING = "orc.block.padding";
    private static MemoryManager memoryManager = null;

    private OrcFile() {
    }

    public static Reader createReader(FileSystem fs, Path path) throws IOException {
        ReaderOptions opts = new ReaderOptions(new Configuration());
        opts.filesystem(fs);
        return new ReaderImpl(path, opts);
    }

    public static ReaderOptions readerOptions(Configuration conf) {
        return new ReaderOptions(conf);
    }

    public static Reader createReader(Path path, ReaderOptions options) throws IOException {
        return new ReaderImpl(path, options);
    }

    public static WriterOptions writerOptions(Configuration conf) {
        return new WriterOptions(conf);
    }

    public static Writer createWriter(Path path, WriterOptions opts) throws IOException {
        FileSystem fs = opts.fileSystemValue == null ? path.getFileSystem(opts.configuration) : opts.fileSystemValue;
        return new WriterImpl(fs, path, opts.configuration, opts.inspectorValue, opts.stripeSizeValue, opts.compressValue, opts.bufferSizeValue, opts.rowIndexStrideValue, opts.memoryManagerValue, opts.blockPaddingValue, opts.versionValue, opts.callback);
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf, ObjectInspector inspector, long stripeSize, CompressionKind compress, int bufferSize, int rowIndexStride) throws IOException {
        return OrcFile.createWriter(path, OrcFile.writerOptions(conf).fileSystem(fs).inspector(inspector).stripeSize(stripeSize).compress(compress).bufferSize(bufferSize).rowIndexStride(rowIndexStride));
    }

    private static synchronized MemoryManager getMemoryManager(Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new MemoryManager(conf);
        }
        return memoryManager;
    }

    public static class WriterOptions {
        private final Configuration configuration;
        private FileSystem fileSystemValue = null;
        private ObjectInspector inspectorValue = null;
        private long stripeSizeValue;
        private int rowIndexStrideValue;
        private int bufferSizeValue;
        private boolean blockPaddingValue;
        private CompressionKind compressValue;
        private MemoryManager memoryManagerValue;
        private Version versionValue;
        private WriterCallback callback;

        WriterOptions(Configuration conf) {
            this.configuration = conf;
            this.memoryManagerValue = OrcFile.getMemoryManager(conf);
            this.stripeSizeValue = conf.getLong(HiveConf.ConfVars.HIVE_ORC_DEFAULT_STRIPE_SIZE.varname, HiveConf.ConfVars.HIVE_ORC_DEFAULT_STRIPE_SIZE.defaultLongVal);
            this.rowIndexStrideValue = conf.getInt(HiveConf.ConfVars.HIVE_ORC_DEFAULT_ROW_INDEX_STRIDE.varname, HiveConf.ConfVars.HIVE_ORC_DEFAULT_ROW_INDEX_STRIDE.defaultIntVal);
            this.bufferSizeValue = conf.getInt(HiveConf.ConfVars.HIVE_ORC_DEFAULT_BUFFER_SIZE.varname, HiveConf.ConfVars.HIVE_ORC_DEFAULT_BUFFER_SIZE.defaultIntVal);
            this.blockPaddingValue = conf.getBoolean(HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_PADDING.varname, HiveConf.ConfVars.HIVE_ORC_DEFAULT_BLOCK_PADDING.defaultBoolVal);
            this.compressValue = CompressionKind.valueOf(conf.get(HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.varname, HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.defaultVal));
            String versionName = conf.get(HiveConf.ConfVars.HIVE_ORC_WRITE_FORMAT.varname);
            this.versionValue = versionName == null ? Version.CURRENT : Version.byName(versionName);
        }

        public WriterOptions fileSystem(FileSystem value) {
            this.fileSystemValue = value;
            return this;
        }

        public WriterOptions stripeSize(long value) {
            this.stripeSizeValue = value;
            return this;
        }

        public WriterOptions rowIndexStride(int value) {
            this.rowIndexStrideValue = value;
            return this;
        }

        public WriterOptions bufferSize(int value) {
            this.bufferSizeValue = value;
            return this;
        }

        public WriterOptions blockPadding(boolean value) {
            this.blockPaddingValue = value;
            return this;
        }

        public WriterOptions compress(CompressionKind value) {
            this.compressValue = value;
            return this;
        }

        public WriterOptions inspector(ObjectInspector value) {
            this.inspectorValue = value;
            return this;
        }

        public WriterOptions version(Version value) {
            this.versionValue = value;
            return this;
        }

        public WriterOptions callback(WriterCallback callback) {
            this.callback = callback;
            return this;
        }

        WriterOptions memory(MemoryManager value) {
            this.memoryManagerValue = value;
            return this;
        }
    }

    public static interface WriterCallback {
        public void preStripeWrite(WriterContext var1) throws IOException;

        public void preFooterWrite(WriterContext var1) throws IOException;
    }

    public static interface WriterContext {
        public Writer getWriter();
    }

    public static class ReaderOptions {
        private final Configuration conf;
        private FileSystem filesystem;
        private ReaderImpl.FileMetaInfo fileMetaInfo;
        private long maxLength = Long.MAX_VALUE;

        ReaderOptions(Configuration conf) {
            this.conf = conf;
        }

        ReaderOptions fileMetaInfo(ReaderImpl.FileMetaInfo info) {
            this.fileMetaInfo = info;
            return this;
        }

        public ReaderOptions filesystem(FileSystem fs) {
            this.filesystem = fs;
            return this;
        }

        public ReaderOptions maxLength(long val) {
            this.maxLength = val;
            return this;
        }

        Configuration getConfiguration() {
            return this.conf;
        }

        FileSystem getFilesystem() {
            return this.filesystem;
        }

        ReaderImpl.FileMetaInfo getFileMetaInfo() {
            return this.fileMetaInfo;
        }

        long getMaxLength() {
            return this.maxLength;
        }
    }

    public static enum OrcTableProperties {
        COMPRESSION("orc.compress"),
        COMPRESSION_BLOCK_SIZE("orc.compress.size"),
        STRIPE_SIZE("orc.stripe.size"),
        ROW_INDEX_STRIDE("orc.row.index.stride"),
        ENABLE_INDEXES("orc.create.index"),
        BLOCK_PADDING("orc.block.padding");

        private final String propName;

        private OrcTableProperties(String propName) {
            this.propName = propName;
        }

        public String getPropName() {
            return this.propName;
        }
    }

    public static enum Version {
        V_0_11("0.11", 0, 11),
        V_0_12("0.12", 0, 12);

        public static final Version CURRENT;
        private final String name;
        private final int major;
        private final int minor;

        private Version(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }

        public static Version byName(String name) {
            for (Version version : Version.values()) {
                if (!version.name.equals(name)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown ORC version " + name);
        }

        public String getName() {
            return this.name;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        static {
            CURRENT = V_0_12;
        }
    }
}

