/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcNewSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class OrcNewInputFormat
extends InputFormat<NullWritable, OrcStruct> {
    private static final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private static final String CLASS_NAME = ReaderImpl.class.getName();

    public org.apache.hadoop.mapreduce.RecordReader<NullWritable, OrcStruct> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Path path = fileSplit.getPath();
        Configuration conf = ShimLoader.getHadoopShims().getConfiguration((JobContext)context);
        return new OrcRecordReader(OrcFile.createReader(path, OrcFile.readerOptions(conf)), ShimLoader.getHadoopShims().getConfiguration((JobContext)context), fileSplit.getStart(), fileSplit.getLength());
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        perfLogger.PerfLogBegin(CLASS_NAME, "OrcGetSplits");
        Configuration conf = ShimLoader.getHadoopShims().getConfiguration(jobContext);
        List<OrcSplit> splits = OrcInputFormat.generateSplitsInfo(ShimLoader.getHadoopShims().getConfiguration(jobContext));
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        for (OrcSplit split : OrcInputFormat.generateSplitsInfo(conf)) {
            result.add((InputSplit)new OrcNewSplit(split));
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "OrcGetSplits");
        return result;
    }

    private static class OrcRecordReader
    extends org.apache.hadoop.mapreduce.RecordReader<NullWritable, OrcStruct> {
        private final RecordReader reader;
        private final int numColumns;
        OrcStruct value;
        private float progress = 0.0f;

        OrcRecordReader(Reader file, Configuration conf, long offset, long length) throws IOException {
            List<OrcProto.Type> types = file.getTypes();
            this.numColumns = types.size() == 0 ? 0 : types.get(0).getSubtypesCount();
            this.value = new OrcStruct(this.numColumns);
            this.reader = OrcInputFormat.createReaderFromFile(file, conf, offset, length);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public NullWritable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public OrcStruct getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.progress;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.reader.hasNext()) {
                this.reader.next(this.value);
                this.progress = this.reader.getProgress();
                return true;
            }
            return false;
        }
    }
}

