/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

class VectorizedOrcAcidRowReader
implements RecordReader<NullWritable, VectorizedRowBatch> {
    private final AcidInputFormat.RowReader<OrcStruct> innerReader;
    private final RecordIdentifier key;
    private final OrcStruct value;
    private final VectorizedRowBatchCtx rowBatchCtx;
    private final ObjectInspector objectInspector;
    private boolean needToSetPartition = true;
    private final DataOutputBuffer buffer = new DataOutputBuffer();

    VectorizedOrcAcidRowReader(AcidInputFormat.RowReader<OrcStruct> inner, Configuration conf, FileSplit split) throws IOException {
        this.innerReader = inner;
        this.key = (RecordIdentifier)inner.createKey();
        this.rowBatchCtx = new VectorizedRowBatchCtx();
        this.value = (OrcStruct)inner.createValue();
        this.objectInspector = inner.getObjectInspector();
        try {
            this.rowBatchCtx.init(conf, split);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to initialize context", e);
        }
        catch (SerDeException e) {
            throw new IOException("Failed to initialize context", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Failed to initialize context", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to initialize context", e);
        }
        catch (HiveException e) {
            throw new IOException("Failed to initialize context", e);
        }
    }

    public boolean next(NullWritable nullWritable, VectorizedRowBatch vectorizedRowBatch) throws IOException {
        vectorizedRowBatch.reset();
        this.buffer.reset();
        if (!this.innerReader.next(this.key, this.value)) {
            return false;
        }
        if (this.needToSetPartition) {
            try {
                this.rowBatchCtx.addPartitionColsToBatch(vectorizedRowBatch);
            }
            catch (HiveException e) {
                throw new IOException("Problem adding partition column", e);
            }
            this.needToSetPartition = false;
        }
        try {
            VectorizedBatchUtil.addRowToBatch(this.value, (StructObjectInspector)this.objectInspector, vectorizedRowBatch.size++, vectorizedRowBatch, this.buffer);
            while (vectorizedRowBatch.size < vectorizedRowBatch.selected.length && this.innerReader.next(this.key, this.value)) {
                VectorizedBatchUtil.addRowToBatch(this.value, (StructObjectInspector)this.objectInspector, vectorizedRowBatch.size++, vectorizedRowBatch, this.buffer);
            }
        }
        catch (HiveException he) {
            throw new IOException("error iterating", he);
        }
        return true;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        try {
            return this.rowBatchCtx.createVectorizedRowBatch();
        }
        catch (HiveException e) {
            throw new RuntimeException("Error creating a batch", e);
        }
    }

    public long getPos() throws IOException {
        return this.innerReader.getPos();
    }

    public void close() throws IOException {
        this.innerReader.close();
    }

    public float getProgress() throws IOException {
        return this.innerReader.getProgress();
    }
}

