/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

public class SimpleFetchOptimizer
implements Transform {
    private final Log LOG = LogFactory.getLog((String)SimpleFetchOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        HashMap<String, Operator<? extends OperatorDesc>> topOps = pctx.getTopOps();
        if (pctx.getQB().isSimpleSelectQuery() && topOps.size() == 1) {
            String alias = (String)pctx.getTopOps().keySet().toArray()[0];
            Operator topOp = (Operator)pctx.getTopOps().values().toArray()[0];
            if (topOp instanceof TableScanOperator) {
                try {
                    FetchTask fetchTask = this.optimize(pctx, alias, (TableScanOperator)topOp);
                    if (fetchTask != null) {
                        pctx.setFetchTask(fetchTask);
                    }
                }
                catch (Exception e) {
                    this.LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    if (e instanceof SemanticException) {
                        throw (SemanticException)e;
                    }
                    throw new SemanticException(e.getMessage(), e);
                }
            }
        }
        return pctx;
    }

    private FetchTask optimize(ParseContext pctx, String alias, TableScanOperator source) throws Exception {
        String mode = HiveConf.getVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEFETCHTASKCONVERSION);
        boolean aggressive = "more".equals(mode);
        FetchData fetch = this.checkTree(aggressive, pctx, alias, source);
        if (fetch != null && this.checkThreshold(fetch, pctx)) {
            int limit = pctx.getQB().getParseInfo().getOuterQueryLimit();
            FetchWork fetchWork = fetch.convertToWork();
            FetchTask fetchTask = (FetchTask)TaskFactory.get(fetchWork, pctx.getConf(), new Task[0]);
            fetchWork.setSink(fetch.completed(pctx, fetchWork));
            fetchWork.setSource(source);
            fetchWork.setLimit(limit);
            return fetchTask;
        }
        return null;
    }

    private boolean checkThreshold(FetchData data, ParseContext pctx) throws Exception {
        long threshold = HiveConf.getLongVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEFETCHTASKCONVERSIONTHRESHOLD);
        if (threshold < 0L) {
            return true;
        }
        long remaining = threshold;
        if ((remaining -= data.getInputLength(pctx, remaining)) < 0L) {
            this.LOG.info((Object)("Threshold " + remaining + " exceeded for pseudoMR mode"));
            return false;
        }
        return true;
    }

    private FetchData checkTree(boolean aggressive, ParseContext pctx, String alias, TableScanOperator ts) throws HiveException {
        SplitSample splitSample = pctx.getNameToSplitSample().get(alias);
        if (!aggressive && splitSample != null) {
            return null;
        }
        QB qb = pctx.getQB();
        if (!aggressive && qb.hasTableSample(alias)) {
            return null;
        }
        Table table = qb.getMetaData().getAliasToTable().get(alias);
        if (table == null) {
            return null;
        }
        ReadEntity parent = PlanUtils.getParentViewInfo(alias, pctx.getViewAliasToInput());
        if (!table.isPartitioned()) {
            return this.checkOperators(new FetchData(parent, table, splitSample), ts, aggressive, false);
        }
        boolean bypassFilter = false;
        if (HiveConf.getBoolVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTPPD)) {
            ExprNodeDesc pruner = pctx.getOpToPartPruner().get(ts);
            bypassFilter = PartitionPruner.onlyContainsPartnCols(table, pruner);
        }
        if (aggressive || bypassFilter) {
            PrunedPartitionList pruned = pctx.getPrunedPartitions(alias, ts);
            if (aggressive || !pruned.hasUnknownPartitions()) {
                return this.checkOperators(new FetchData(parent, table, pruned, splitSample), ts, aggressive, bypassFilter &= !pruned.hasUnknownPartitions());
            }
        }
        return null;
    }

    private FetchData checkOperators(FetchData fetch, TableScanOperator ts, boolean aggresive, boolean bypassFilter) {
        if (ts.getChildOperators().size() != 1) {
            return null;
        }
        Operator<OperatorDesc> op = ts.getChildOperators().get(0);
        while (!(!aggresive ? !(op instanceof LimitOperator) && (!(op instanceof FilterOperator) || !bypassFilter) && (!(op instanceof SelectOperator) || !((SelectDesc)((SelectOperator)op).getConf()).isSelectStar()) : !(op instanceof LimitOperator) && !(op instanceof FilterOperator) && !(op instanceof SelectOperator))) {
            if (op.getChildOperators() == null || op.getChildOperators().size() != 1) {
                return null;
            }
            op = op.getChildOperators().get(0);
        }
        if (op instanceof FileSinkOperator) {
            fetch.scanOp = ts;
            fetch.fileSink = op;
            return fetch;
        }
        return null;
    }

    public static ListSinkOperator replaceFSwithLS(Operator<?> fileSink, String nullFormat) {
        ListSinkOperator sink = new ListSinkOperator();
        sink.setConf(new ListSinkDesc(nullFormat));
        sink.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
        Operator<OperatorDesc> parent = fileSink.getParentOperators().get(0);
        sink.getParentOperators().add(parent);
        parent.replaceChild(fileSink, sink);
        fileSink.setParentOperators(null);
        return sink;
    }

    private class FetchData {
        private final ReadEntity parent;
        private final Table table;
        private final SplitSample splitSample;
        private final PrunedPartitionList partsList;
        private final HashSet<ReadEntity> inputs = new HashSet();
        private TableScanOperator scanOp;
        private Operator<?> fileSink;

        private FetchData(ReadEntity parent, Table table, SplitSample splitSample) {
            this.parent = parent;
            this.table = table;
            this.partsList = null;
            this.splitSample = splitSample;
        }

        private FetchData(ReadEntity parent, Table table, PrunedPartitionList partsList, SplitSample splitSample) {
            this.parent = parent;
            this.table = table;
            this.partsList = partsList;
            this.splitSample = splitSample;
        }

        private FetchWork convertToWork() throws HiveException {
            this.inputs.clear();
            if (!this.table.isPartitioned()) {
                this.inputs.add(new ReadEntity(this.table, this.parent));
                FetchWork work = new FetchWork(this.table.getPath(), Utilities.getTableDesc(this.table));
                PlanUtils.configureInputJobPropertiesForStorageHandler(work.getTblDesc());
                work.setSplitSample(this.splitSample);
                return work;
            }
            ArrayList<Path> listP = new ArrayList<Path>();
            ArrayList<PartitionDesc> partP = new ArrayList<PartitionDesc>();
            for (Partition partition : this.partsList.getNotDeniedPartns()) {
                this.inputs.add(new ReadEntity(partition, this.parent));
                listP.add(partition.getDataLocation());
                partP.add(Utilities.getPartitionDesc(partition));
            }
            Table sourceTable = this.partsList.getSourceTable();
            this.inputs.add(new ReadEntity(sourceTable, this.parent));
            TableDesc table = Utilities.getTableDesc(sourceTable);
            FetchWork work = new FetchWork(listP, partP, table);
            if (!work.getPartDesc().isEmpty()) {
                PartitionDesc part0 = work.getPartDesc().get(0);
                PlanUtils.configureInputJobPropertiesForStorageHandler(part0.getTableDesc());
                work.setSplitSample(this.splitSample);
            }
            return work;
        }

        private ListSinkOperator completed(ParseContext pctx, FetchWork work) {
            for (ReadEntity input : this.inputs) {
                PlanUtils.addInput(pctx.getSemanticInputs(), input);
            }
            return SimpleFetchOptimizer.replaceFSwithLS(this.fileSink, work.getSerializationNullFormat());
        }

        private long getInputLength(ParseContext pctx, long remaining) throws Exception {
            if (this.splitSample != null && this.splitSample.getTotalLength() != null) {
                return this.splitSample.getTotalLength();
            }
            long length = this.calculateLength(pctx, remaining);
            if (this.splitSample != null) {
                return this.splitSample.getTargetSize(length);
            }
            return length;
        }

        private long calculateLength(ParseContext pctx, long remaining) throws Exception {
            JobConf jobConf = new JobConf((Configuration)pctx.getConf());
            Utilities.setColumnNameList(jobConf, this.scanOp, true);
            Utilities.setColumnTypeList(jobConf, this.scanOp, true);
            HiveStorageHandler handler = this.table.getStorageHandler();
            if (handler instanceof InputEstimator) {
                InputEstimator estimator = (InputEstimator)((Object)handler);
                TableDesc tableDesc = Utilities.getTableDesc(this.table);
                PlanUtils.configureInputJobPropertiesForStorageHandler(tableDesc);
                Utilities.copyTableJobPropertiesToConf(tableDesc, jobConf);
                return estimator.estimate(jobConf, this.scanOp, remaining).getTotalLength();
            }
            if (this.table.isNonNative()) {
                return 0L;
            }
            if (!this.table.isPartitioned()) {
                return this.getFileLength(jobConf, this.table.getPath(), this.table.getInputFormatClass());
            }
            long total = 0L;
            for (Partition partition : this.partsList.getNotDeniedPartns()) {
                Path path = partition.getDataLocation();
                total += this.getFileLength(jobConf, path, partition.getInputFormatClass());
            }
            return total;
        }

        private long getFileLength(JobConf conf, Path path, Class<? extends InputFormat> clazz) throws IOException {
            ContentSummary summary;
            if (ContentSummaryInputFormat.class.isAssignableFrom(clazz)) {
                InputFormat<WritableComparable, Writable> input = HiveInputFormat.getInputFormatFromCache(clazz, conf);
                summary = ((ContentSummaryInputFormat)input).getContentSummary(path, conf);
            } else {
                summary = path.getFileSystem((Configuration)conf).getContentSummary(path);
            }
            return summary.getLength();
        }
    }
}

