/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpProcFactory;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpWalkerCtx;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartExprEvalUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public class PartitionPruner
implements Transform {
    public static final String CLASS_NAME = PartitionPruner.class.getName();
    public static final Log LOG = LogFactory.getLog((String)CLASS_NAME);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        OpWalkerCtx opWalkerCtx = new OpWalkerCtx(pctx.getOpToPartPruner());
        PrunerUtils.walkOperatorTree(pctx, opWalkerCtx, OpProcFactory.getFilterProc(), OpProcFactory.getDefaultProc());
        return pctx;
    }

    public static boolean onlyContainsPartnCols(Table tab, ExprNodeDesc expr) {
        if (!tab.isPartitioned() || expr == null) {
            return true;
        }
        if (expr instanceof ExprNodeColumnDesc) {
            String colName = ((ExprNodeColumnDesc)expr).getColumn();
            return tab.isPartitionKey(colName);
        }
        if (expr instanceof ExprNodeGenericFuncDesc && !FunctionRegistry.isDeterministic(((ExprNodeGenericFuncDesc)expr).getGenericUDF())) {
            return false;
        }
        List<ExprNodeDesc> children = expr.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (PartitionPruner.onlyContainsPartnCols(tab, children.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static PrunedPartitionList prune(TableScanOperator ts, ParseContext parseCtx, String alias) throws HiveException {
        return PartitionPruner.prune(parseCtx.getTopToTable().get(ts), parseCtx.getOpToPartPruner().get(ts), parseCtx.getConf(), alias, parseCtx.getPrunedPartitions());
    }

    private static PrunedPartitionList prune(Table tab, ExprNodeDesc prunerExpr, HiveConf conf, String alias, Map<String, PrunedPartitionList> prunedPartitionsMap) throws HiveException {
        PrunedPartitionList ret;
        LOG.trace((Object)"Started pruning partiton");
        LOG.trace((Object)("dbname = " + tab.getDbName()));
        LOG.trace((Object)("tabname = " + tab.getTableName()));
        LOG.trace((Object)("prune Expression = " + prunerExpr));
        String key = tab.getDbName() + "." + tab.getTableName() + ";";
        if (prunerExpr != null) {
            key = key + prunerExpr.getExprString();
        }
        if ((ret = prunedPartitionsMap.get(key)) != null) {
            return ret;
        }
        ret = PartitionPruner.getPartitionsFromServer(tab, prunerExpr, conf, alias);
        prunedPartitionsMap.put(key, ret);
        return ret;
    }

    private static ExprNodeDesc compactExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeConstantDesc) {
            if (((ExprNodeConstantDesc)expr).getValue() == null) {
                return null;
            }
            throw new IllegalStateException("Unexpected non-null ExprNodeConstantDesc: " + expr.getExprString());
        }
        if (expr instanceof ExprNodeGenericFuncDesc) {
            GenericUDF udf = ((ExprNodeGenericFuncDesc)expr).getGenericUDF();
            boolean isAnd = udf instanceof GenericUDFOPAnd;
            if (isAnd || udf instanceof GenericUDFOPOr) {
                List<ExprNodeDesc> children = expr.getChildren();
                ExprNodeDesc left = children.get(0);
                children.set(0, PartitionPruner.compactExpr(left));
                ExprNodeDesc right = children.get(1);
                children.set(1, PartitionPruner.compactExpr(right));
                if (children.get(0) == null && children.get(1) == null) {
                    return null;
                }
                if (children.get(0) == null) {
                    return isAnd ? children.get(1) : null;
                }
                if (children.get(1) == null) {
                    return isAnd ? children.get(0) : null;
                }
            }
            return (ExprNodeGenericFuncDesc)expr;
        }
        throw new IllegalStateException("Unexpected type of ExprNodeDesc: " + expr.getExprString());
    }

    private static ExprNodeDesc removeNonPartCols(ExprNodeDesc expr, List<String> partCols) {
        if (expr instanceof ExprNodeColumnDesc && !partCols.contains(((ExprNodeColumnDesc)expr).getColumn())) {
            return new ExprNodeConstantDesc(expr.getTypeInfo(), null);
        }
        if (expr instanceof ExprNodeGenericFuncDesc) {
            List<ExprNodeDesc> children = expr.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                children.set(i, PartitionPruner.removeNonPartCols(children.get(i), partCols));
            }
        }
        return expr;
    }

    private static boolean hasUserFunctions(ExprNodeDesc expr) {
        if (!(expr instanceof ExprNodeGenericFuncDesc)) {
            return false;
        }
        if (!FunctionRegistry.isNativeFuncExpr((ExprNodeGenericFuncDesc)expr)) {
            return true;
        }
        for (ExprNodeDesc child : expr.getChildren()) {
            if (!PartitionPruner.hasUserFunctions(child)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrunedPartitionList getPartitionsFromServer(Table tab, ExprNodeDesc prunerExpr, HiveConf conf, String alias) throws HiveException {
        try {
            if (!tab.isPartitioned()) {
                return new PrunedPartitionList(tab, PartitionPruner.getAllPartitions(tab), false);
            }
            LOG.debug((Object)("tabname = " + tab.getTableName() + " is partitioned"));
            if ("strict".equalsIgnoreCase(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPREDMODE)) && !PartitionPruner.hasColumnExpr(prunerExpr)) {
                throw new SemanticException(ErrorMsg.NO_PARTITION_PREDICATE.getMsg("for Alias \"" + alias + "\" Table \"" + tab.getTableName() + "\""));
            }
            if (prunerExpr == null) {
                return new PrunedPartitionList(tab, PartitionPruner.getAllPartitions(tab), false);
            }
            prunerExpr = PartitionPruner.removeNonPartCols(prunerExpr, PartitionPruner.extractPartColNames(tab));
            ExprNodeGenericFuncDesc compactExpr = (ExprNodeGenericFuncDesc)PartitionPruner.compactExpr(prunerExpr.clone());
            String oldFilter = prunerExpr.getExprString();
            if (compactExpr == null) {
                LOG.debug((Object)("Filter " + oldFilter + " was null after compacting"));
                return new PrunedPartitionList(tab, PartitionPruner.getAllPartitions(tab), true);
            }
            LOG.debug((Object)("Filter w/ compacting: " + compactExpr.getExprString() + "; filter w/o compacting: " + oldFilter));
            boolean doEvalClientSide = PartitionPruner.hasUserFunctions(compactExpr);
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            boolean hasUnknownPartitions = false;
            PerfLogger perfLogger = PerfLogger.getPerfLogger();
            if (!doEvalClientSide) {
                perfLogger.PerfLogBegin(CLASS_NAME, "partition-retrieving");
                try {
                    hasUnknownPartitions = Hive.get().getPartitionsByExpr(tab, compactExpr, conf, partitions);
                }
                catch (IMetaStoreClient.IncompatibleMetastoreException ime) {
                    LOG.warn((Object)"Metastore doesn't support getPartitionsByExpr", (Throwable)ime);
                    doEvalClientSide = true;
                }
                finally {
                    perfLogger.PerfLogEnd(CLASS_NAME, "partition-retrieving");
                }
            }
            if (doEvalClientSide) {
                hasUnknownPartitions = PartitionPruner.pruneBySequentialScan(tab, partitions, compactExpr, conf);
            }
            boolean isPruningByExactFilter = oldFilter.equals(compactExpr.getExprString());
            return new PrunedPartitionList(tab, new LinkedHashSet<Partition>(partitions), hasUnknownPartitions || !isPruningByExactFilter);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static Set<Partition> getAllPartitions(Table tab) throws HiveException {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "partition-retrieving");
        Set<Partition> result = Hive.get().getAllPartitionsOf(tab);
        perfLogger.PerfLogEnd(CLASS_NAME, "partition-retrieving");
        return result;
    }

    private static boolean pruneBySequentialScan(Table tab, List<Partition> partitions, ExprNodeGenericFuncDesc prunerExpr, HiveConf conf) throws HiveException, MetaException {
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "prune-listing");
        List<String> partNames = Hive.get().getPartitionNames(tab.getDbName(), tab.getTableName(), (short)-1);
        String defaultPartitionName = conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME);
        List<String> partCols = PartitionPruner.extractPartColNames(tab);
        boolean hasUnknownPartitions = PartitionPruner.prunePartitionNames(partCols, prunerExpr, defaultPartitionName, partNames);
        perfLogger.PerfLogEnd(CLASS_NAME, "prune-listing");
        perfLogger.PerfLogBegin(CLASS_NAME, "partition-retrieving");
        if (!partNames.isEmpty()) {
            partitions.addAll(Hive.get().getPartitionsByNames(tab, partNames));
        }
        perfLogger.PerfLogEnd(CLASS_NAME, "partition-retrieving");
        return hasUnknownPartitions;
    }

    private static List<String> extractPartColNames(Table tab) {
        List<FieldSchema> pCols = tab.getPartCols();
        ArrayList<String> partCols = new ArrayList<String>(pCols.size());
        for (FieldSchema pCol : pCols) {
            partCols.add(pCol.getName());
        }
        return partCols;
    }

    public static boolean prunePartitionNames(List<String> columnNames, ExprNodeGenericFuncDesc prunerExpr, String defaultPartitionName, List<String> partNames) throws HiveException, MetaException {
        ObjectPair<PrimitiveObjectInspector, ExprNodeEvaluator> handle = PartExprEvalUtils.prepareExpr(prunerExpr, columnNames);
        boolean inPlace = partNames instanceof AbstractSequentialList;
        LinkedList partNamesSeq = inPlace ? partNames : new LinkedList(partNames);
        ArrayList values = new ArrayList(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            values.add(null);
        }
        boolean hasUnknownPartitions = false;
        Iterator partIter = partNamesSeq.iterator();
        while (partIter.hasNext()) {
            boolean isUnknown;
            String partName = (String)partIter.next();
            Warehouse.makeValsFromName((String)partName, values);
            Boolean isNeeded = (Boolean)PartExprEvalUtils.evaluateExprOnPart(handle, values);
            boolean bl = isUnknown = isNeeded == null;
            if (!isUnknown && !isNeeded.booleanValue()) {
                partIter.remove();
                continue;
            }
            if (isUnknown && values.contains(defaultPartitionName)) {
                LOG.debug((Object)("skipping default/bad partition: " + partName));
                partIter.remove();
                continue;
            }
            hasUnknownPartitions |= isUnknown;
            LOG.debug((Object)("retained " + (isUnknown ? "unknown " : "") + "partition: " + partName));
        }
        if (!inPlace) {
            partNames.clear();
            partNames.addAll(partNamesSeq);
        }
        return hasUnknownPartitions;
    }

    public static boolean hasColumnExpr(ExprNodeDesc desc) {
        if (desc == null) {
            return false;
        }
        if (desc instanceof ExprNodeColumnDesc) {
            return true;
        }
        List<ExprNodeDesc> children = desc.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                if (!PartitionPruner.hasColumnExpr(children.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

