/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CopyWork;

public class ExportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    public ExportSemanticAnalyzer(HiveConf conf) throws SemanticException {
        super(conf);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        Tree tableTree = ast.getChild(0);
        Tree toTree = ast.getChild(1);
        String tmpPath = ExportSemanticAnalyzer.stripQuotes(toTree.getText());
        URI toURI = EximUtil.getValidatedURI(this.conf, tmpPath);
        BaseSemanticAnalyzer.tableSpec ts = new BaseSemanticAnalyzer.tableSpec(this.db, this.conf, (ASTNode)tableTree, false, true);
        EximUtil.validateTable(ts.tableHandle);
        try {
            FileSystem fs = FileSystem.get((URI)toURI, (Configuration)this.conf);
            Path toPath = new Path(toURI.getScheme(), toURI.getAuthority(), toURI.getPath());
            try {
                FileStatus tgt = fs.getFileStatus(toPath);
                if (!tgt.isDir()) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "Target is not a directory : " + toURI));
                }
                FileStatus[] files = fs.listStatus(toPath);
                if (files != null && files.length != 0) {
                    throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast, "Target is not an empty directory : " + toURI));
                }
            }
            catch (FileNotFoundException e) {}
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(ast), e);
        }
        List<Partition> partitions = null;
        try {
            partitions = null;
            if (ts.tableHandle.isPartitioned()) {
                partitions = ts.partitions != null ? ts.partitions : this.db.getPartitions(ts.tableHandle);
            }
            Path path = new Path(this.ctx.getLocalTmpPath(), "_metadata");
            EximUtil.createExportDump((FileSystem)FileSystem.getLocal((Configuration)this.conf), path, ts.tableHandle, partitions);
            Task<CopyWork> rTask = TaskFactory.get(new CopyWork(path, new Path(toURI), false), this.conf, new Task[0]);
            this.rootTasks.add(rTask);
            this.LOG.debug((Object)("_metadata file written into " + path.toString() + " and then copied to " + toURI.toString()));
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg("Exception while writing out the local file"), e);
        }
        Path parentPath = new Path(toURI);
        if (ts.tableHandle.isPartitioned()) {
            for (Partition partition : partitions) {
                Path fromPath = partition.getDataLocation();
                Path toPartPath = new Path(parentPath, partition.getName());
                Task<CopyWork> rTask = TaskFactory.get(new CopyWork(fromPath, toPartPath, false), this.conf, new Task[0]);
                this.rootTasks.add(rTask);
                this.inputs.add(new ReadEntity(partition));
            }
        } else {
            Path fromPath = ts.tableHandle.getDataLocation();
            Path toDataPath = new Path(parentPath, "data");
            Task<CopyWork> rTask = TaskFactory.get(new CopyWork(fromPath, toDataPath, false), this.conf, new Task[0]);
            this.rootTasks.add(rTask);
            this.inputs.add(new ReadEntity(ts.tableHandle));
        }
        this.outputs.add(new WriteEntity(parentPath, toURI.getScheme().equals("hdfs")));
    }
}

