/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionWork;

public class GenTezUtils {
    private static final Log LOG = LogFactory.getLog((String)GenTezUtils.class.getName());
    private int sequenceNumber = 0;
    private static GenTezUtils utils;

    public static GenTezUtils getUtils() {
        if (utils == null) {
            utils = new GenTezUtils();
        }
        return utils;
    }

    protected GenTezUtils() {
    }

    public void resetSequenceNumber() {
        this.sequenceNumber = 0;
    }

    public UnionWork createUnionWork(GenTezProcContext context, Operator<?> operator, TezWork tezWork) {
        UnionWork unionWork = new UnionWork("Union " + ++this.sequenceNumber);
        context.unionWorkMap.put(operator, unionWork);
        tezWork.add(unionWork);
        return unionWork;
    }

    public ReduceWork createReduceWork(GenTezProcContext context, Operator<?> root, TezWork tezWork) {
        assert (!root.getParentOperators().isEmpty());
        ReduceWork reduceWork = new ReduceWork("Reducer " + ++this.sequenceNumber);
        LOG.debug((Object)("Adding reduce work (" + reduceWork.getName() + ") for " + root));
        reduceWork.setReducer(root);
        reduceWork.setNeedsTagging(GenMapRedUtils.needsTagging(reduceWork));
        assert (context.parentOfRoot instanceof ReduceSinkOperator);
        ReduceSinkOperator reduceSink = (ReduceSinkOperator)context.parentOfRoot;
        reduceWork.setNumReduceTasks(((ReduceSinkDesc)reduceSink.getConf()).getNumReducers());
        this.setupReduceSink(context, reduceWork, reduceSink);
        tezWork.add(reduceWork);
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        tezWork.connect(context.preceedingWork, reduceWork, edgeProp);
        context.connectedReduceSinks.add(reduceSink);
        return reduceWork;
    }

    protected void setupReduceSink(GenTezProcContext context, ReduceWork reduceWork, ReduceSinkOperator reduceSink) {
        LOG.debug((Object)("Setting up reduce sink: " + reduceSink + " with following reduce work: " + reduceWork.getName()));
        GenMapRedUtils.setKeyAndValueDesc(reduceWork, reduceSink);
        reduceWork.getTagToInput().put(((ReduceSinkDesc)reduceSink.getConf()).getTag(), context.preceedingWork.getName());
        ((ReduceSinkDesc)reduceSink.getConf()).setOutputName(reduceWork.getName());
    }

    public MapWork createMapWork(GenTezProcContext context, Operator<?> root, TezWork tezWork, PrunedPartitionList partitions) throws SemanticException {
        assert (root.getParentOperators().isEmpty());
        MapWork mapWork = new MapWork("Map " + ++this.sequenceNumber);
        LOG.debug((Object)("Adding map work (" + mapWork.getName() + ") for " + root));
        assert (root instanceof TableScanOperator);
        String alias = ((TableScanDesc)((TableScanOperator)root).getConf()).getAlias();
        this.setupMapWork(mapWork, context, partitions, root, alias);
        tezWork.add(mapWork);
        return mapWork;
    }

    protected void setupMapWork(MapWork mapWork, GenTezProcContext context, PrunedPartitionList partitions, Operator<? extends OperatorDesc> root, String alias) throws SemanticException {
        GenMapRedUtils.setMapWork(mapWork, context.parseContext, context.inputs, partitions, root, alias, context.conf, false);
    }

    public void removeUnionOperators(Configuration conf, GenTezProcContext context, BaseWork work) throws SemanticException {
        Set<Operator<?>> roots = work.getAllRootOperators();
        if (work.getDummyOps() != null) {
            roots.addAll(work.getDummyOps());
        }
        Set<Operator<?>> newRoots = Utilities.cloneOperatorTree(conf, roots);
        HashMap replacementMap = new HashMap();
        LinkedList<HashTableDummyOperator> dummyOps = new LinkedList<HashTableDummyOperator>();
        Iterator<Operator<?>> it = newRoots.iterator();
        for (Operator<?> orig : roots) {
            Operator<?> newRoot = it.next();
            if (newRoot instanceof HashTableDummyOperator) {
                dummyOps.add((HashTableDummyOperator)newRoot);
                it.remove();
                continue;
            }
            replacementMap.put(orig, newRoot);
        }
        LinkedList operators = new LinkedList();
        operators.addAll(newRoots);
        HashSet<Operator> seen = new HashSet<Operator>();
        while (!operators.isEmpty()) {
            Operator current = (Operator)operators.pop();
            seen.add(current);
            if (current instanceof FileSinkOperator) {
                List<Object> linked;
                FileSinkOperator fileSink = (FileSinkOperator)current;
                context.fileSinkSet.add(fileSink);
                FileSinkDesc desc = (FileSinkDesc)fileSink.getConf();
                Path path = desc.getDirName();
                if (!context.linkedFileSinks.containsKey(path)) {
                    linked = new ArrayList();
                    context.linkedFileSinks.put(path, linked);
                }
                linked = context.linkedFileSinks.get(path);
                linked.add(desc);
                desc.setDirName(new Path(path, "" + linked.size()));
                desc.setLinkedFileSinkDesc(linked);
            }
            if (current instanceof UnionOperator) {
                Operator<OperatorDesc> parent = null;
                int count = 0;
                for (Operator<OperatorDesc> op : current.getParentOperators()) {
                    if (!seen.contains(op)) continue;
                    ++count;
                    parent = op;
                }
                assert (count <= 1);
                if (parent == null) {
                    replacementMap.put(current, current.getChildOperators().get(0));
                } else {
                    parent.removeChildAndAdoptItsChildren(current);
                }
            }
            if (current instanceof FileSinkOperator || current instanceof ReduceSinkOperator) {
                current.setChildOperators(null);
                continue;
            }
            operators.addAll(current.getChildOperators());
        }
        work.setDummyOps(dummyOps);
        work.replaceRoots(replacementMap);
    }

    public void processFileSink(GenTezProcContext context, FileSinkOperator fileSink) throws SemanticException {
        ParseContext parseContext = context.parseContext;
        boolean isInsertTable = GenMapRedUtils.isInsertInto(parseContext, fileSink);
        HiveConf hconf = parseContext.getConf();
        boolean chDir = GenMapRedUtils.isMergeRequired(context.moveTask, hconf, fileSink, context.currentTask, isInsertTable);
        Path finalName = GenMapRedUtils.createMoveTask(context.currentTask, chDir, fileSink, parseContext, context.moveTask, hconf, context.dependencyTask);
        if (chDir) {
            LOG.info((Object)"using CombineHiveInputformat for the merge job");
            GenMapRedUtils.createMRWorkForMergingFiles(fileSink, finalName, context.dependencyTask, context.moveTask, hconf, context.currentTask);
        }
    }
}

