/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.CompositeProcessor;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ForwardWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.optimizer.ConvertJoinMapJoin;
import org.apache.hadoop.hive.ql.optimizer.ReduceSinkMapJoinProc;
import org.apache.hadoop.hive.ql.optimizer.SetReducerParallelism;
import org.apache.hadoop.hive.ql.optimizer.physical.CrossProductCheck;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.StageIDsRearranger;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.parse.FileSinkProcessor;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.GenTezWork;
import org.apache.hadoop.hive.ql.parse.GenTezWorkWalker;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ProcessAnalyzeTable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TaskCompiler;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;

public class TezCompiler
extends TaskCompiler {
    protected final Log LOG = LogFactory.getLog(TezCompiler.class);

    @Override
    public void init(HiveConf conf, SessionState.LogHelper console, Hive db) {
        super.init(conf, console, db);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN, (boolean)true);
        conf.setBoolean("mapred.input.dir.recursive", true);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES, (boolean)true);
    }

    @Override
    protected void optimizeOperatorPlan(ParseContext pCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        LinkedList deque = new LinkedList();
        deque.addAll(pCtx.getTopOps().values());
        OptimizeTezProcContext procCtx = new OptimizeTezProcContext(this.conf, pCtx, inputs, outputs, deque);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp(new String("Set parallelism - ReduceSink"), ReduceSinkOperator.getOperatorName() + "%"), new SetReducerParallelism());
        opRules.put(new RuleRegExp(new String("Convert Join to Map-join"), JoinOperator.getOperatorName() + "%"), new ConvertJoinMapJoin());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ForwardWalker ogw = new ForwardWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    @Override
    protected void generateTaskTree(List<Task<? extends Serializable>> rootTasks, ParseContext pCtx, List<Task<MoveWork>> mvTask, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        GenTezUtils.getUtils().resetSequenceNumber();
        ParseContext tempParseContext = this.getParseContext(pCtx, rootTasks);
        GenTezWork genTezWork = new GenTezWork(GenTezUtils.getUtils());
        GenTezProcContext procCtx = new GenTezProcContext(this.conf, tempParseContext, mvTask, rootTasks, inputs, outputs);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("Split Work - ReduceSink", ReduceSinkOperator.getOperatorName() + "%"), genTezWork);
        opRules.put(new RuleRegExp("No more walking on ReduceSink-MapJoin", MapJoinOperator.getOperatorName() + "%"), new ReduceSinkMapJoinProc());
        opRules.put(new RuleRegExp("Split Work + Move/Merge - FileSink", FileSinkOperator.getOperatorName() + "%"), new CompositeProcessor(new FileSinkProcessor(), genTezWork));
        opRules.put(new RuleRegExp("Handle Potential Analyze Command", TableScanOperator.getOperatorName() + "%"), new ProcessAnalyzeTable(GenTezUtils.getUtils()));
        opRules.put(new RuleRegExp("Remember union", UnionOperator.getOperatorName() + "%"), new NodeProcessor(){

            @Override
            public Object process(Node n, Stack<Node> s, NodeProcessorCtx procCtx, Object ... os) throws SemanticException {
                GenTezProcContext context = (GenTezProcContext)procCtx;
                UnionOperator union = (UnionOperator)n;
                context.currentUnionOperators.add(union);
                return null;
            }
        });
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        GenTezWorkWalker ogw = new GenTezWorkWalker(disp, procCtx);
        ogw.startWalking(topNodes, null);
        for (BaseWork w : procCtx.workWithUnionOperators) {
            GenTezUtils.getUtils().removeUnionOperators((Configuration)this.conf, procCtx, w);
        }
        for (FileSinkOperator fileSink : procCtx.fileSinkSet) {
            GenTezUtils.getUtils().processFileSink(procCtx, fileSink);
        }
    }

    @Override
    protected void setInputFormat(Task<? extends Serializable> task) {
        if (task instanceof TezTask) {
            TezWork work = (TezWork)((TezTask)task).getWork();
            List<BaseWork> all = work.getAllWork();
            for (BaseWork w : all) {
                MapWork mapWork;
                LinkedHashMap<String, Operator<? extends OperatorDesc>> opMap;
                if (!(w instanceof MapWork) || (opMap = (mapWork = (MapWork)w).getAliasToWork()).isEmpty()) continue;
                for (Operator op : ((HashMap)opMap).values()) {
                    this.setInputFormat(mapWork, op);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<? extends Serializable> tsk : listTasks) {
                this.setInputFormat(tsk);
            }
        }
        if (task.getChildTasks() != null) {
            for (Task<Serializable> childTask : task.getChildTasks()) {
                this.setInputFormat(childTask);
            }
        }
    }

    private void setInputFormat(MapWork work, Operator<? extends OperatorDesc> op) {
        if (op.isUseBucketizedHiveInputFormat()) {
            work.setUseBucketizedHiveInputFormat(true);
            return;
        }
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
                this.setInputFormat(work, childOp);
            }
        }
    }

    @Override
    protected void decideExecMode(List<Task<? extends Serializable>> rootTasks, Context ctx, GlobalLimitCtx globalLimitCtx) throws SemanticException {
    }

    @Override
    protected void optimizeTaskPlan(List<Task<? extends Serializable>> rootTasks, ParseContext pCtx, Context ctx) throws SemanticException {
        PhysicalContext physicalCtx = new PhysicalContext(this.conf, pCtx, pCtx.getContext(), rootTasks, pCtx.getFetchTask());
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CHECK_CROSS_PRODUCT)) {
            physicalCtx = new CrossProductCheck().resolve(physicalCtx);
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED)) {
            new Vectorizer().resolve(physicalCtx);
        }
        if (!"none".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.HIVESTAGEIDREARRANGE))) {
            new StageIDsRearranger().resolve(physicalCtx);
        }
    }
}

