/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.JobConf;

public class ReduceWork
extends BaseWork {
    private static final transient Log LOG = LogFactory.getLog(ReduceWork.class);
    private TableDesc keyDesc;
    private List<TableDesc> tagToValueDesc = new ArrayList<TableDesc>();
    private Operator<?> reducer;
    private Integer numReduceTasks;
    private boolean needsTagging;
    private Map<Integer, String> tagToInput = new HashMap<Integer, String>();

    public ReduceWork() {
    }

    public ReduceWork(String name) {
        super(name);
    }

    public void setKeyDesc(TableDesc keyDesc) {
        this.keyDesc = keyDesc;
    }

    public TableDesc getKeyDesc() {
        return this.keyDesc;
    }

    public List<TableDesc> getTagToValueDesc() {
        return this.tagToValueDesc;
    }

    public void setTagToValueDesc(List<TableDesc> tagToValueDesc) {
        this.tagToValueDesc = tagToValueDesc;
    }

    @Explain(displayName="Execution mode")
    public String getVectorModeOn() {
        return this.vectorMode ? "vectorized" : null;
    }

    @Explain(displayName="Reduce Operator Tree")
    public Operator<?> getReducer() {
        return this.reducer;
    }

    public void setReducer(Operator<?> reducer) {
        this.reducer = reducer;
    }

    @Explain(displayName="Needs Tagging", normalExplain=false)
    public boolean getNeedsTagging() {
        return this.needsTagging;
    }

    public void setNeedsTagging(boolean needsTagging) {
        this.needsTagging = needsTagging;
    }

    public void setTagToInput(Map<Integer, String> tagToInput) {
        this.tagToInput = tagToInput;
    }

    public Map<Integer, String> getTagToInput() {
        return this.tagToInput;
    }

    @Override
    public void replaceRoots(Map<Operator<?>, Operator<?>> replacementMap) {
        assert (replacementMap.size() == 1);
        this.setReducer(replacementMap.get(this.getReducer()));
    }

    @Override
    public Set<Operator<?>> getAllRootOperators() {
        LinkedHashSet opSet = new LinkedHashSet();
        opSet.add(this.getReducer());
        return opSet;
    }

    public Integer getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(Integer numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    @Override
    public void configureJobConf(JobConf job) {
        if (this.reducer != null) {
            for (FileSinkOperator fs : OperatorUtils.findOperators(this.reducer, FileSinkOperator.class)) {
                PlanUtils.configureJobConf(((FileSinkDesc)fs.getConf()).getTableInfo(), job);
            }
        }
    }
}

