/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;

@InterfaceAudience.LimitedPrivate(value={"Sql standard authorization plugin"})
public class AuthorizationUtils {
    public static HivePrincipal.HivePrincipalType getHivePrincipalType(PrincipalType type) throws HiveException {
        switch (type) {
            case USER: {
                return HivePrincipal.HivePrincipalType.USER;
            }
            case ROLE: {
                return HivePrincipal.HivePrincipalType.ROLE;
            }
            case GROUP: {
                throw new HiveException(ErrorMsg.UNNSUPPORTED_AUTHORIZATION_PRINCIPAL_TYPE_GROUP, new String[0]);
            }
        }
        throw new AssertionError((Object)"Unsupported authorization type specified");
    }

    public static HivePrivilegeObject.HivePrivilegeObjectType getHivePrivilegeObjectType(Entity.Type type) {
        switch (type) {
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
            case LOCAL_DIR: {
                return HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI;
            }
            case DFS_DIR: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI;
            }
            case PARTITION: 
            case DUMMYPARTITION: {
                return HivePrivilegeObject.HivePrivilegeObjectType.PARTITION;
            }
        }
        return null;
    }

    public static PrincipalType getThriftPrincipalType(HivePrincipal.HivePrincipalType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case USER: {
                return PrincipalType.USER;
            }
            case ROLE: {
                return PrincipalType.ROLE;
            }
        }
        throw new AssertionError((Object)("Invalid principal type " + (Object)((Object)type)));
    }

    public static PrivilegeGrantInfo getThriftPrivilegeGrantInfo(HivePrivilege privilege, HivePrincipal grantorPrincipal, boolean grantOption, int grantTime) throws HiveException {
        return new PrivilegeGrantInfo(privilege.getName(), grantTime, grantorPrincipal.getName(), AuthorizationUtils.getThriftPrincipalType(grantorPrincipal.getType()), grantOption);
    }

    public static HiveObjectType getThriftHiveObjType(HivePrivilegeObject.HivePrivilegeObjectType type) throws HiveException {
        if (type == null) {
            return null;
        }
        switch (type) {
            case DATABASE: {
                return HiveObjectType.DATABASE;
            }
            case TABLE_OR_VIEW: {
                return HiveObjectType.TABLE;
            }
            case PARTITION: {
                return HiveObjectType.PARTITION;
            }
            case LOCAL_URI: 
            case DFS_URI: {
                throw new HiveException("Unsupported type " + (Object)((Object)type));
            }
        }
        throw new AssertionError((Object)("Unsupported type " + (Object)((Object)type)));
    }

    public static HiveObjectRef getThriftHiveObjectRef(HivePrivilegeObject privObj) throws HiveException {
        if (privObj == null) {
            return null;
        }
        HiveObjectType objType = AuthorizationUtils.getThriftHiveObjType(privObj.getType());
        return new HiveObjectRef(objType, privObj.getDbname(), privObj.getTableViewURI(), null, null);
    }
}

