/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={""})
@InterfaceStability.Unstable
public class HivePrivilegeObject {
    private final HivePrivilegeObjectType type;
    private final String dbname;
    private final String tableviewname;

    public String toString() {
        String name = null;
        switch (this.type) {
            case DATABASE: {
                name = this.dbname;
                break;
            }
            case TABLE_OR_VIEW: {
                name = (this.dbname == null ? "" : this.dbname + ".") + this.tableviewname;
                break;
            }
            case LOCAL_URI: 
            case DFS_URI: {
                name = this.tableviewname;
                break;
            }
        }
        return "Object [type=" + (Object)((Object)this.type) + ", name=" + name + "]";
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String tableViewURI) {
        this.type = type;
        this.dbname = dbname;
        this.tableviewname = tableViewURI;
    }

    public HivePrivilegeObjectType getType() {
        return this.type;
    }

    public String getDbname() {
        return this.dbname;
    }

    public String getTableViewURI() {
        return this.tableviewname;
    }

    public static enum HivePrivilegeObjectType {
        DATABASE,
        TABLE_OR_VIEW,
        PARTITION,
        LOCAL_URI,
        DFS_URI;

    }
}

