/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.CompactionTxnHandler;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

abstract class CompactorThread
extends Thread
implements MetaStoreThread {
    private static final String CLASS_NAME = CompactorThread.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected HiveConf conf;
    protected CompactionTxnHandler txnHandler;
    protected RawStore rs;
    protected int threadId;
    protected MetaStoreThread.BooleanPointer stop;

    CompactorThread() {
    }

    public void setHiveConf(HiveConf conf) {
        this.conf = conf;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public void init(MetaStoreThread.BooleanPointer stop) throws MetaException {
        this.stop = stop;
        this.setPriority(1);
        this.setDaemon(true);
        this.txnHandler = new CompactionTxnHandler(this.conf);
        this.rs = RawStoreProxy.getProxy((HiveConf)this.conf, (Configuration)this.conf, (String)this.conf.getVar(HiveConf.ConfVars.METASTORE_RAW_STORE_IMPL), (int)this.threadId);
    }

    protected Table resolveTable(CompactionInfo ci) throws MetaException {
        try {
            return this.rs.getTable(ci.dbname, ci.tableName);
        }
        catch (MetaException e) {
            LOG.error((Object)("Unable to find table " + ci.getFullTableName() + ", " + e.getMessage()));
            throw e;
        }
    }

    protected Partition resolvePartition(CompactionInfo ci) throws Exception {
        Object p = null;
        if (ci.partName != null) {
            ArrayList<String> names = new ArrayList<String>(1);
            names.add(ci.partName);
            List parts = null;
            try {
                parts = this.rs.getPartitionsByNames(ci.dbname, ci.tableName, names);
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to find partition " + ci.getFullPartitionName() + ", " + e.getMessage()));
                throw e;
            }
            if (parts.size() != 1) {
                LOG.error((Object)(ci.getFullPartitionName() + " does not refer to a single partition"));
                throw new MetaException("Too many partitions");
            }
            return (Partition)parts.get(0);
        }
        return null;
    }

    protected StorageDescriptor resolveStorageDescriptor(Table t, Partition p) {
        return p == null ? t.getSd() : p.getSd();
    }

    protected String findUserToRunAs(String location, Table t) throws IOException, InterruptedException {
        LOG.debug((Object)"Determining who to run the job as.");
        final Path p = new Path(location);
        final FileSystem fs = p.getFileSystem((Configuration)this.conf);
        try {
            FileStatus stat = fs.getFileStatus(p);
            LOG.debug((Object)("Running job as " + stat.getOwner()));
            return stat.getOwner();
        }
        catch (AccessControlException e) {
            LOG.debug((Object)"Unable to stat file as current user, trying as table owner");
            final ArrayList wrapper = new ArrayList(1);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileStatus stat = fs.getFileStatus(p);
                    wrapper.add(stat.getOwner());
                    return null;
                }
            });
            if (wrapper.size() == 1) {
                LOG.debug((Object)("Running job as " + (String)wrapper.get(0)));
                return (String)wrapper.get(0);
            }
            LOG.error((Object)"Unable to stat file as either current user or table owner, giving up");
            throw new IOException("Unable to stat file");
        }
    }

    protected boolean runJobAsSelf(String owner) {
        return owner.equals(System.getProperty("user.name"));
    }

    protected String tableName(Table t) {
        return t.getDbName() + "." + t.getTableName();
    }
}

