/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.util.Version;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;

public class JedisVersionUtil {
    private static Version jedisVersion = JedisVersionUtil.parseVersion(JedisVersionUtil.resolveJedisVersion());

    public static Version jedisVersion() {
        return jedisVersion;
    }

    static Version parseVersion(String version) {
        return Version.parse((String)version);
    }

    public static boolean atLeastJedis24() {
        return JedisVersionUtil.atLeast("2.4");
    }

    private static String resolveJedisVersion() {
        String version = Jedis.class.getPackage().getImplementationVersion();
        if (!StringUtils.hasText((String)version)) {
            try {
                Properties props = PropertiesLoaderUtils.loadAllProperties((String)"META-INF/maven/redis.clients/jedis/pom.properties");
                if (props.containsKey("version")) {
                    version = props.getProperty("version");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version;
    }

    public static boolean atLeast(String version) {
        return jedisVersion.compareTo(JedisVersionUtil.parseVersion(version)) >= 0;
    }

    public static boolean atMost(String version) {
        return jedisVersion.compareTo(JedisVersionUtil.parseVersion(version)) <= 0;
    }
}

