/*
 * Decompiled with CFR 0.152.
 */
package protobuf.codec.json;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import protobuf.codec.AbstractCodec;
import protobuf.codec.Codec;
import protobuf.codec.ParseException;
import protobuf.codec.json.JsonCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonJsonReader {
    public static Message parse(Message.Builder builder, JsonParser parser, ExtensionRegistry extnRegistry, Map<Codec.Feature, Object> featureMap) throws IOException {
        parser.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, ((Boolean)featureMap.get(Codec.Feature.CLOSE_STREAM)).booleanValue());
        parser.nextToken();
        JacksonJsonReader.parseObject(builder, parser, extnRegistry, featureMap);
        return builder.build();
    }

    private static Message.Builder parseObject(Message.Builder builder, JsonParser parser, ExtensionRegistry extnRegistry, Map<Codec.Feature, Object> featureMap) throws IOException {
        if (!JsonToken.START_OBJECT.equals((Object)parser.getCurrentToken())) {
            throw new ParseException("Parser should point to a START_OBJECT event");
        }
        Descriptors.Descriptor descriptor = builder.getDescriptorForType();
        while (!parser.nextToken().equals((Object)JsonToken.END_OBJECT)) {
            JsonToken currToken = parser.getCurrentToken();
            assert (currToken.equals((Object)JsonToken.FIELD_NAME));
            String fieldName = parser.getCurrentName();
            fieldName = AbstractCodec.stripFieldName((String)fieldName, featureMap);
            fieldName = AbstractCodec.substituteFieldNameForReading((String)fieldName, featureMap);
            Descriptors.FieldDescriptor field = null;
            if (AbstractCodec.isExtensionFieldName((String)fieldName, featureMap)) {
                ExtensionRegistry.ExtensionInfo extnInfo = extnRegistry.findExtensionByName(fieldName = JsonCodec.parseExtensionFieldName((String)fieldName, featureMap));
                if (extnInfo == null) {
                    parser.nextToken();
                    if (!JsonToken.START_ARRAY.equals((Object)parser.getCurrentToken()) && !JsonToken.START_OBJECT.equals((Object)parser.getCurrentToken())) continue;
                    parser.skipChildren();
                    continue;
                }
                field = extnInfo.descriptor;
            } else {
                if (AbstractCodec.isFieldNameUnknownField((String)fieldName, featureMap)) {
                    parser.nextToken();
                    if (!AbstractCodec.supportUnknownFields(featureMap)) continue;
                    String unknownFieldsText = parser.getText();
                    AbstractCodec.mergeUnknownFieldsFromString((Message.Builder)builder, (ExtensionRegistry)extnRegistry, (String)unknownFieldsText);
                    continue;
                }
                field = descriptor.findFieldByName(fieldName);
            }
            if (field == null) {
                throw new ParseException("Field cannot be null, processing fieldName " + fieldName);
            }
            parser.nextToken();
            JacksonJsonReader.setFields(builder, field, parser, extnRegistry, featureMap);
        }
        return builder;
    }

    private static Message.Builder setFields(Message.Builder builder, Descriptors.FieldDescriptor field, JsonParser parser, ExtensionRegistry extnRegistry, Map<Codec.Feature, Object> featureMap) throws IOException {
        Object value = JacksonJsonReader.getValue(builder, field, parser, extnRegistry, featureMap);
        if (value != null) {
            builder.setField(field, value);
        }
        return builder;
    }

    private static void handleArray(Message.Builder builder, Descriptors.FieldDescriptor arrayField, JsonParser parser, ExtensionRegistry extnRegistry, Map<Codec.Feature, Object> featureMap) throws IOException {
        while (!JsonToken.END_ARRAY.equals((Object)parser.nextToken())) {
            JsonToken token = parser.getCurrentToken();
            if (JsonToken.START_ARRAY.equals((Object)token)) continue;
            Object value = JacksonJsonReader.getValue(builder, arrayField, parser, extnRegistry, featureMap);
            builder.addRepeatedField(arrayField, value);
        }
    }

    private static Object getValue(Message.Builder builder, Descriptors.FieldDescriptor field, JsonParser parser, ExtensionRegistry extnRegistry, Map<Codec.Feature, Object> featureMap) throws IOException {
        JsonToken token = parser.getCurrentToken();
        Object value = null;
        switch (token) {
            case VALUE_STRING: {
                if (Descriptors.FieldDescriptor.JavaType.ENUM.equals((Object)field.getJavaType())) {
                    value = field.getEnumType().findValueByName(parser.getText());
                    break;
                }
                if (Descriptors.FieldDescriptor.JavaType.STRING.equals((Object)field.getJavaType())) {
                    value = parser.getText();
                    break;
                }
                if (Descriptors.FieldDescriptor.JavaType.BYTE_STRING.equals((Object)field.getJavaType())) {
                    value = ByteString.copyFrom((byte[])Base64.decodeBase64((String)parser.getText()));
                    break;
                }
                throw new UnsupportedEncodingException(String.format("Unsupported java type [%s] for field [%s] for json type VALUE_STRING", field.getJavaType(), field.getName()));
            }
            case VALUE_TRUE: {
                value = Boolean.TRUE;
                break;
            }
            case VALUE_FALSE: {
                value = Boolean.FALSE;
                break;
            }
            case VALUE_NUMBER_INT: {
                if (field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.INT)) {
                    value = parser.getIntValue();
                    break;
                }
                if (Descriptors.FieldDescriptor.JavaType.LONG.equals((Object)field.getJavaType())) {
                    value = parser.getLongValue();
                    break;
                }
                throw new UnsupportedEncodingException(String.format("Unsupported java type [%s] for field [%s] for json type VALUE_NUMBER_INT", field.getJavaType(), field.getName()));
            }
            case VALUE_NUMBER_FLOAT: {
                if (Descriptors.FieldDescriptor.JavaType.DOUBLE.equals((Object)field.getJavaType())) {
                    value = parser.getDoubleValue();
                    break;
                }
                if (Descriptors.FieldDescriptor.JavaType.FLOAT.equals((Object)field.getJavaType())) {
                    value = Float.valueOf(parser.getFloatValue());
                    break;
                }
                throw new UnsupportedEncodingException(String.format("Unsupported java type [%s] for field [%s] for json type VALUE_NUMBER_FLOAT", field.getJavaType(), field.getName()));
            }
            case START_OBJECT: {
                Message.Builder newBuilder = null;
                newBuilder = field.isExtension() ? extnRegistry.findExtensionByName((String)field.getFullName()).defaultInstance.toBuilder() : builder.newBuilderForField(field);
                value = JacksonJsonReader.parseObject(newBuilder, parser, extnRegistry, featureMap).build();
                break;
            }
            case START_ARRAY: {
                JacksonJsonReader.handleArray(builder, field, parser, extnRegistry, featureMap);
                break;
            }
            case VALUE_NULL: {
                break;
            }
            default: {
                throw new UnsupportedEncodingException(String.format("Unsupported token type [%s]", token));
            }
        }
        return value;
    }
}

