/*
 * Decompiled with CFR 0.152.
 */
package protobuf.codec.json;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.JsonGenerator;
import protobuf.codec.AbstractCodec;
import protobuf.codec.Codec;
import protobuf.codec.json.JsonCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonJsonWriter {
    public static void generateJSONFields(Message message, JsonGenerator generator, Map<Codec.Feature, Object> featureMap) throws IOException {
        generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, ((Boolean)featureMap.get(Codec.Feature.CLOSE_STREAM)).booleanValue());
        if (AbstractCodec.prettyPrint(featureMap)) {
            generator.useDefaultPrettyPrinter();
        }
        if (!AbstractCodec.closeStream(featureMap)) {
            generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        }
        generator.writeStartObject();
        for (Map.Entry record : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)record.getKey();
            String fieldName = field.isExtension() ? JsonCodec.getExtensionFieldName((String)field.getName(), featureMap) : field.getName();
            fieldName = AbstractCodec.substituteFieldNameForWriting((String)fieldName, featureMap);
            Object value = record.getValue();
            if (field.isRepeated()) {
                generator.writeArrayFieldStart(fieldName);
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    JacksonJsonWriter.writeFieldValue(field, iter.next(), generator, featureMap);
                }
                generator.writeEndArray();
                continue;
            }
            generator.writeFieldName(fieldName);
            JacksonJsonWriter.writeFieldValue(field, value, generator, featureMap);
        }
        if (AbstractCodec.supportUnknownFields(featureMap)) {
            JacksonJsonWriter.writeUnknownFieldSet(message.getUnknownFields(), generator, featureMap);
        }
        generator.writeEndObject();
    }

    private static void writeFieldValue(Descriptors.FieldDescriptor fieldDesc, Object value, JsonGenerator generator, Map<Codec.Feature, Object> featureMap) throws IOException {
        switch (fieldDesc.getJavaType()) {
            case INT: {
                generator.writeNumber(((Integer)value).intValue());
                break;
            }
            case LONG: {
                generator.writeNumber(((Long)value).longValue());
                break;
            }
            case FLOAT: {
                generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber(((Double)value).doubleValue());
                break;
            }
            case BOOLEAN: {
                generator.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case STRING: {
                generator.writeString((String)value);
                break;
            }
            case ENUM: {
                generator.writeString(((Descriptors.EnumValueDescriptor)value).getName());
                break;
            }
            case BYTE_STRING: {
                generator.writeString(Base64.encodeBase64String((byte[])((ByteString)value).toByteArray()));
                break;
            }
            case MESSAGE: {
                JacksonJsonWriter.generateJSONFields((Message)value, generator, featureMap);
                break;
            }
            default: {
                throw new UnsupportedEncodingException(String.format("Unspupported protobuf java field type [%s] for field [%s] ", fieldDesc.getJavaType(), fieldDesc.getName()));
            }
        }
    }

    private static void writeUnknownFieldSet(UnknownFieldSet unknownFields, JsonGenerator generator, Map<Codec.Feature, Object> featureMap) throws IOException {
        if (unknownFields != null && unknownFields.asMap().size() > 0) {
            generator.writeStringField(AbstractCodec.getUnknownFieldElementName(featureMap), AbstractCodec.encodeUnknownFieldsToString((UnknownFieldSet)unknownFields));
        }
    }
}

