/*
 * Decompiled with CFR 0.152.
 */
package protobuf.codec.json;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import protobuf.codec.AbstractCodec;
import protobuf.codec.Codec;
import protobuf.codec.json.JacksonJsonReader;
import protobuf.codec.json.JacksonJsonWriter;

public class JsonCodec
extends AbstractCodec {
    protected Message readFromStream(Message.Builder builder, Reader reader, ExtensionRegistry extnRegistry) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser parser = jsonFactory.createJsonParser(reader);
        return JacksonJsonReader.parse(builder, parser, extnRegistry, this.getAllFeaturesSet());
    }

    protected void writeToStream(Message message, Writer writer) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonGenerator generator = jsonFactory.createJsonGenerator(writer);
        JacksonJsonWriter.generateJSONFields(message, generator, this.getAllFeaturesSet());
        generator.close();
    }

    public void validateAndSetFeature(Codec.Feature feature, Object value) {
        switch (feature) {
            case SUPPORT_UNKNOWN_FIELDS: 
            case PRETTY_PRINT: 
            case CLOSE_STREAM: {
                if (Boolean.TRUE.equals(value) || Boolean.FALSE.equals(value)) break;
                throw new IllegalArgumentException(String.format("Unsupported value [%s] for feature [%s]", value, feature));
            }
            case UNKNOWN_FIELD_ELEM_NAME: 
            case EXTENSION_FIELD_NAME_PREFIX: {
                if (value != null && String.class.isAssignableFrom(value.getClass()) && !((String)value).trim().equals("")) break;
                throw new IllegalArgumentException(String.format("Feature [%s] expected to be a non null string", feature));
            }
            case FIELD_NAME_READ_SUBSTITUTES: 
            case FIELD_NAME_WRITE_SUBSTITUTES: 
            case STRIP_FIELD_NAME_UNDERSCORES: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported feature [%s]", feature));
            }
        }
    }
}

