/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.api.Sections;

public class NewsDb
implements Serializable {
    private static final long serialVersionUID = 4587045119864760513L;
    private static final Logger log = LoggerFactory.getLogger(NewsDb.class);
    private Map<String, List<NewsItem>> itemsBySection;
    private Map<String, NewsItem> itemBySlug;
    private Map<String, NewsItem> itemByUrl;
    private static NewsDb instance = new NewsDb();
    private List<NewsItem> editorial;
    private List<NewsItem> articles;
    private List<NewsItem> headlines;
    private List<NewsItem> lusaArticles;
    private HashMap<String, List<NewsItem>> latestNews;
    private Date lastModified = new Date();

    private NewsDb() {
        File adbFile = new File("./news.db");
        if (adbFile.exists()) {
            try (FileInputStream fis = new FileInputStream(adbFile);
                 ObjectInputStream in = new ObjectInputStream(fis);){
                NewsDb ard = (NewsDb)in.readObject();
                this.init(ard.doGetAllEditorial(), ard.doGetAllHeadlines(), ard.doGetAllArticles(), ard.doGetAllLatestNews(), ard.doGetLusaLatestNews());
            }
            catch (Throwable t) {
                Shutdown.now((Throwable)t);
            }
        } else {
            List<NewsItem> empty = Collections.emptyList();
            this.init(empty, empty, empty, new HashMap<String, List<NewsItem>>(), empty);
        }
    }

    private NewsDb(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles) {
        this.init(editorial, headlines, articles);
    }

    private NewsDb(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles, HashMap<String, List<NewsItem>> lNews, List<NewsItem> lusaArticles) {
        this.init(editorial, headlines, articles, lNews, lusaArticles);
    }

    private void init(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles, HashMap<String, List<NewsItem>> lNews, List<NewsItem> lusaArticles) {
        this.itemsBySection = new HashMap<String, List<NewsItem>>();
        this.itemBySlug = new HashMap<String, NewsItem>();
        this.itemByUrl = new HashMap<String, NewsItem>();
        this.editorial = editorial;
        this.headlines = headlines;
        this.articles = articles;
        this.latestNews = lNews;
        this.lusaArticles = lusaArticles;
        for (String section : Sections.get()) {
            ArrayList all = new ArrayList();
            try {
                editorial.stream().filter(ni -> ni.getSection().equals(section)).forEach(i -> all.add(i));
                headlines.stream().filter(ni -> ni.getSection().equals(section)).forEach(i -> all.add(i));
                articles.stream().filter(ni -> ni.getSection().equals(section)).forEach(i -> all.add(i));
            }
            catch (Throwable t) {
                log.error("Editorial: ", editorial);
                log.error("headlines: ", headlines);
                log.error("articles: ", articles);
                t.printStackTrace();
            }
            this.itemsBySection.put(section, all);
        }
        this.fillLookupTables(editorial);
        this.fillLookupTables(headlines);
        this.fillLookupTables(articles);
        this.fillLookupTables(this.latestNews);
        this.fillLookupTables(lusaArticles);
        this.lastModified = new Date();
    }

    private void init(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles) {
        this.itemsBySection = new HashMap<String, List<NewsItem>>();
        this.itemBySlug = new HashMap<String, NewsItem>();
        this.itemByUrl = new HashMap<String, NewsItem>();
        this.editorial = editorial;
        this.headlines = headlines;
        this.articles = articles;
        for (String section : Sections.get()) {
            ArrayList all = new ArrayList();
            try {
                editorial.stream().filter(ni -> ni.getSection().equals(section)).forEach(i -> all.add(i));
                headlines.stream().filter(ni -> ni.getSection().equals(section)).forEach(i -> all.add(i));
                articles.stream().filter(ni -> ni.getSection().equals(section)).forEach(i -> all.add(i));
            }
            catch (Throwable t) {
                log.error("Editorial: ", editorial);
                log.error("headlines: ", headlines);
                log.error("articles: ", articles);
                t.printStackTrace();
            }
            this.itemsBySection.put(section, all);
        }
        this.fillLookupTables(editorial);
        this.fillLookupTables(headlines);
        this.fillLookupTables(articles);
        this.fillLookupTables(this.latestNews);
        this.lastModified = new Date();
    }

    private void fillLookupTables(HashMap<String, List<NewsItem>> lst) {
        for (Map.Entry<String, List<NewsItem>> entry : lst.entrySet()) {
            if (entry.getValue() == null) continue;
            for (NewsItem ni : entry.getValue()) {
                NewsItem niBySlug;
                if (this.itemBySlug.get(ni.getSlug()) != null) {
                    niBySlug = this.itemBySlug.get(ni.getSlug());
                    niBySlug.setNextByHost(ni.getNextByHost());
                } else {
                    this.itemBySlug.put(ni.getSlug(), ni);
                }
                if (this.itemByUrl.get(ni.getSlug()) != null) {
                    niBySlug = this.itemByUrl.get(ni.getSlug());
                    niBySlug.setNextByHost(ni.getNextByHost());
                    continue;
                }
                this.itemByUrl.put(ni.getUrl(), ni);
            }
        }
    }

    private void fillLookupTables(List<NewsItem> lst) {
        if (lst != null) {
            for (NewsItem ni : lst) {
                this.itemBySlug.put(ni.getSlug(), ni);
                this.itemByUrl.put(ni.getUrl(), ni);
            }
        }
    }

    public static final void build(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles) {
        log.info("build(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles)");
        NewsDb adb = headlines == null || headlines.isEmpty() ? new NewsDb(editorial, instance.getAllHeadlines(), instance.getAllArticles()) : new NewsDb(editorial, headlines, articles);
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles, HashMap<String, List<NewsItem>> lNews, List<NewsItem> lusaArticles) {
        log.info("build(List<NewsItem> editorial, List<NewsItem> headlines, List<NewsItem> articles,HashMap<String, List<NewsItem>> lNews, List<NewsItem> lusaArticles)");
        NewsDb adb = headlines == null || headlines.isEmpty() ? new NewsDb(editorial, instance.getAllHeadlines(), instance.getAllArticles()) : new NewsDb(editorial, headlines, articles, lNews, lusaArticles);
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(List<NewsItem> editorial) {
        log.info("build(List<NewsItem> editorial)");
        List<NewsItem> allArticles = instance.getAllArticles();
        String slug1 = editorial.get(0).getSlug();
        String slug2 = editorial.get(1).getSlug();
        String slug3 = editorial.get(2).getSlug();
        int i = 0;
        for (NewsItem article : allArticles) {
            String slug = article.getSlug();
            if (slug.equalsIgnoreCase(slug1)) {
                allArticles.get(i).setPosition(editorial.get(0).getPosition());
                allArticles.get(i).setNextByPosition(editorial.get(0).getNextByPosition());
                log.error("######replace article position");
            } else if (slug.equalsIgnoreCase(slug2)) {
                allArticles.get(i).setPosition(editorial.get(1).getPosition());
                allArticles.get(i).setNextByPosition(editorial.get(1).getNextByPosition());
                log.error("######replace article position");
            } else if (slug.equalsIgnoreCase(slug3)) {
                allArticles.get(i).setPosition(editorial.get(2).getPosition());
                allArticles.get(i).setNextByPosition(editorial.get(2).getNextByPosition());
                log.error("######replace article position");
            }
            ++i;
        }
        NewsDb adb = new NewsDb(editorial, instance.getAllHeadlines(), instance.getAllArticles(), instance.doGetAllLatestNews(), instance.getAllLusaLatestNews());
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(InputStream input) {
        log.info("build(InputStream input)");
        try (ObjectInputStream in = new ObjectInputStream(input);){
            NewsDb adb = (NewsDb)in.readObject();
            NewsDb.dump(adb);
            instance = adb;
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static final void buildEditorial(InputStream input) {
        log.info("build(InputStream input)");
        System.out.println("buildEditorial(InputStream input)");
        try (ObjectInputStream in = new ObjectInputStream(input);){
            NewsDb adbDb = (NewsDb)in.readObject();
            log.info("############## obj: {}", adbDb.editorial);
            List<NewsItem> lst_editorial = adbDb.editorial;
            NewsDb adb = instance;
            log.debug("lst_editorial: {}", lst_editorial);
            adb.editorial = lst_editorial;
            NewsDb.dump(adb, "buildEditorial");
            instance = adb;
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    private static synchronized void dump(NewsDb adb) {
        File outFile = new File("./news.db.tmp");
        try (FileOutputStream fileOut = new FileOutputStream(outFile);
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            out.writeObject(adb);
            out.close();
            fileOut.close();
            File dstFile = new File("./news.db");
            Files.move(outFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    private static synchronized void dump(NewsDb adb, String filename) {
        if (filename == null || filename.isEmpty()) {
            filename = "news.db";
        }
        File outFile = new File("./" + filename + ".tmp");
        try (FileOutputStream fileOut = new FileOutputStream(outFile);
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            out.writeObject(adb);
            out.close();
            fileOut.close();
            File dstFile = new File("./" + filename + ".db");
            Files.move(outFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    private List<NewsItem> doGetAllEditorial() {
        return this.editorial;
    }

    private List<NewsItem> doGetAllArticles() {
        return this.articles;
    }

    private List<NewsItem> doGetAllHeadlines() {
        return this.headlines;
    }

    private List<NewsItem> doGetLusaLatestNews() {
        return this.lusaArticles;
    }

    private List<NewsItem> doGetAllLatestNews(String host) {
        return this.latestNews.get(host);
    }

    private HashMap<String, List<NewsItem>> doGetAllLatestNews() {
        return this.latestNews;
    }

    private Date doGetLastModified() {
        return this.lastModified;
    }

    public static final List<NewsItem> getSection(String section) {
        if (StringUtils.isBlank((CharSequence)section)) {
            return new ArrayList<NewsItem>(instance.doGetAllArticles());
        }
        return new ArrayList<NewsItem>((Collection)NewsDb.instance.itemsBySection.get(section));
    }

    public static final List<NewsItem> getAllEditorial() {
        return new ArrayList<NewsItem>(instance.doGetAllEditorial());
    }

    public static final List<NewsItem> getAllArticles() {
        return new ArrayList<NewsItem>(instance.doGetAllArticles());
    }

    public static final List<NewsItem> getAllLusaLatestNews() {
        return new ArrayList<NewsItem>(instance.doGetLusaLatestNews());
    }

    public static final List<NewsItem> getAllHeadlines() {
        return new ArrayList<NewsItem>(instance.doGetAllHeadlines());
    }

    public static final List<NewsItem> getAllLatestNews(String host) {
        List<NewsItem> lst_temp = instance.doGetAllLatestNews(host);
        if (lst_temp == null) {
            return new ArrayList<NewsItem>();
        }
        return new ArrayList<NewsItem>(instance.doGetAllLatestNews(host));
    }

    public static final List<NewsItem> getAllLatestNews() {
        ArrayList<NewsItem> arTemp = new ArrayList<NewsItem>();
        for (Map.Entry<String, List<NewsItem>> entry : instance.doGetAllLatestNews().entrySet()) {
            arTemp.addAll((Collection<NewsItem>)entry.getValue());
        }
        return arTemp;
    }

    public static final NewsItem getArticleBySlug(String slug) {
        return NewsDb.instance.itemBySlug.get(slug);
    }

    public static final NewsItem getArticleByUrl(String url) {
        return NewsDb.instance.itemByUrl.get(url);
    }

    public static Date getLastModified() {
        return instance.doGetLastModified();
    }
}

