/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.caudexorigo.text.HtmlStripper;

public class Text {
    private static final Text instance = new Text();
    private final Set<String> stop_words = new HashSet<String>();

    private Text() {
        this.init();
    }

    private void init() {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(Text.class.getResourceAsStream("/stop_words.txt")));
            String line = null;
            while ((line = r.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                this.stop_words.add(line.trim());
            }
            r.close();
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static boolean isStopWord(String word) {
        return Text.instance.stop_words.contains(word);
    }

    public static List<String> tokenize(String text) {
        try {
            ArrayList<String> r = new ArrayList<String>();
            if (text == null) {
                System.out.println("Text.tokenize: text is null");
            }
            char[] chars = text.toLowerCase().toCharArray();
            StringBuilder sb = new StringBuilder();
            for (char c : chars) {
                if (!Character.isLetterOrDigit(c)) {
                    String part;
                    String part0 = sb.toString();
                    if (StringUtils.isNotBlank((CharSequence)part0) && !Text.isStopWord(part = part0) && part.length() > 1) {
                        r.add(part);
                    }
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(c);
            }
            return r;
        }
        catch (Throwable t) {
            System.out.println("Text.tokenize.text: " + text);
            throw new RuntimeException(t);
        }
    }

    public static String getSummary(String text, int i, boolean removeTags) {
        if (removeTags && text != null) {
            text = HtmlStripper.strip((String)text);
        }
        String result = Text.getSummary(text, i);
        return result;
    }

    public static String getSummary(String text, int i) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        char[] chars = text.toCharArray();
        int total = chars.length - 1;
        StringBuilder lead = new StringBuilder();
        StringBuilder paragraph = new StringBuilder();
        int j = 0;
        for (char c : chars) {
            if (c == '.' || c == '\n' || c == '?' || c == '!') {
                paragraph.append(c);
                if (paragraph.length() + lead.length() > i && lead.length() > 0) break;
                if (j < total && j > 0) {
                    char next = chars[j + 1];
                    if (c != '\n' && next != ' ') continue;
                }
                lead.append(paragraph.toString());
                paragraph.delete(0, paragraph.length());
            } else {
                paragraph.append(c);
            }
            ++j;
        }
        return lead.toString();
    }
}

