/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import pt.sapo.hp24.api.Dimensions;
import pt.sapo.hp24.api.ImageGallery;
import pt.sapo.hp24.api.RelatedVideo;
import pt.sapo.hp24.api.Site;
import pt.sapo.hp24.tools.Articles;
import pt.sapo.hp24.tools.Host;
import pt.sapo.hp24.tools.Text;
import pt.sapo.hp24.tools.ThumbsEpic;
import pt.sapo.hp24.tools.Url;

public class NewsItem
implements Serializable {
    private static final long serialVersionUID = 6025509033284719728L;
    private static Pattern link = Pattern.compile("file=.*");
    private String url;
    private String host;
    private String title;
    private String editorialTitle;
    private String editorialLead;
    private String lead;
    private String label;
    private String body;
    private Set<String> categories;
    private Set<String> topics;
    private Set<String> sections;
    private Set<String> images;
    private Set<String> highlightImages;
    private List<String> thumbs;
    private List<String> highlightThumbs;
    private List<NewsItem> similarItems;
    private boolean isValid;
    private int wordCount;
    private int socialActionCount;
    private String slug;
    private double score;
    private Date pubDate;
    private Date changeDate;
    private String fmtDate;
    private Map<String, Dimensions> imageDimensions;
    private Map<String, String> imageCredits;
    private String hostIcon;
    private String nextByCategory;
    private String nextByPosition;
    private String nextByHost;
    private String nextByLatestHost;
    private String keywords;
    private int position;
    private String clean_body;
    private String sourceName;
    private List<RelatedVideo> relatedVideos;
    private boolean isVidPreProc;
    private boolean requiresPayment;
    private ImageGallery imageGallery;
    private boolean hasImageGallery;
    private Set<String> videos;
    private String author;
    private String source_type;
    private Map<String, Integer> social_shares;

    public Map<String, String> getImageCredits() {
        return this.imageCredits;
    }

    public void setImageCredits(Map<String, String> imageCredits) {
        this.imageCredits = imageCredits;
    }

    public NewsItem(String url) {
        this.url = url;
    }

    public void addCategories(Collection<String> categories) {
        if (this.categories == null) {
            this.categories = new HashSet<String>();
        }
        if (categories != null) {
            this.categories.addAll(categories);
        }
    }

    public void addSections(Set<String> sections) {
        if (this.sections == null) {
            this.sections = new HashSet<String>();
        }
        if (sections != null) {
            this.sections.addAll(sections);
        }
    }

    public void addSimilar(NewsItem similarItem) {
        if (similarItem != null) {
            if (this.similarItems == null) {
                this.similarItems = new ArrayList<NewsItem>();
            }
            this.similarItems.add(similarItem);
        }
    }

    public void addTopics(Collection<String> topics) {
        if (this.topics == null) {
            this.topics = new HashSet<String>();
        }
        if (topics != null) {
            this.topics.addAll(topics);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewsItem other = (NewsItem)obj;
        return !(this.slug == null ? other.slug != null : !this.slug.equals(other.slug));
    }

    public String getBody() {
        return this.body;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public int getContentCount() {
        if (this.similarItems == null) {
            return 1;
        }
        return 1 + this.similarItems.size();
    }

    public String getFmtPubDate() {
        Date curr_day = DateUtils.truncate((Date)new Date(), (int)5);
        Date doc_day = DateUtils.truncate((Date)this.pubDate, (int)5);
        if (curr_day.getTime() == doc_day.getTime()) {
            return StringUtils.substringBefore((String)this.fmtDate, (String)",");
        }
        return this.fmtDate;
    }

    public boolean getHasImages() {
        if (this.images == null) {
            return false;
        }
        return this.images.size() > 0;
    }

    public boolean getHasThumbs() {
        if (this.thumbs == null) {
            return false;
        }
        return this.thumbs.size() > 0;
    }

    public String getHost() {
        return this.host;
    }

    public String getCpId() {
        return Host.getCpId(this.getHost());
    }

    public String getHostIcon() {
        return this.hostIcon;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getLead() {
        return this.lead;
    }

    public String getNextByCategory() {
        return StringUtils.trimToEmpty((String)this.nextByCategory);
    }

    public String getNextByPosition() {
        return StringUtils.trimToEmpty((String)this.nextByPosition);
    }

    public String getNextByHost() {
        return StringUtils.trimToEmpty((String)this.nextByHost);
    }

    public String getNextByLatestHost() {
        return StringUtils.trimToEmpty((String)this.nextByLatestHost);
    }

    public String getPath() {
        return "/article/" + this.getSlug();
    }

    public String getPermaLink() {
        return Site.MAIN_URL + "article/" + this.getSlug();
    }

    public Set<String> getImages() {
        return this.images;
    }

    public Set<String> getHighlightImages() {
        return this.highlightImages;
    }

    public String getPhotoUrl() {
        for (String url : this.getImages()) {
            if (!StringUtils.isNotBlank((CharSequence)url)) continue;
            return url;
        }
        return "";
    }

    public int getImagesCount() {
        if (this.images == null) {
            return 0;
        }
        return this.images.size();
    }

    public int getPosition() {
        return this.position;
    }

    public Date getPubDate() {
        return this.pubDate;
    }

    public String getSafePermaLink() {
        return Url.enc(this.getPermaLink());
    }

    public double getScore() {
        return this.score;
    }

    public String getSection() {
        if (Articles.isOpinion(this)) {
            return "opiniao";
        }
        if (this.sections != null) {
            for (String section : this.sections) {
                if ("actualidade".equals(section)) continue;
                return section;
            }
        }
        return "actualidade";
    }

    public Set<String> getSections() {
        return this.sections;
    }

    public List<NewsItem> getSimilarItems() {
        return this.similarItems == null ? Collections.emptyList() : this.similarItems;
    }

    public String getSlug() {
        return this.slug;
    }

    public int getSocialActionCount() {
        return 1 + this.socialActionCount;
    }

    public Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        tags.addAll(this.getTopics());
        tags.addAll(this.getSections());
        tags.addAll(this.getCategories());
        return tags;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.trimToEmpty((String)this.getTitle()));
        sb.append(' ');
        sb.append(StringUtils.trimToEmpty((String)this.getCleanBody()));
        sb.append(' ');
        sb.append(StringUtils.trimToEmpty((String)StringUtils.join(this.getCategories(), (char)' ')));
        return StringUtils.join(Text.tokenize(sb.toString()), (char)' ');
    }

    private String getCleanBody() {
        return this.clean_body;
    }

    public String getLeadText() {
        return StringUtils.join(Text.tokenize(this.getTitle() + " " + this.getLead()), (char)' ');
    }

    public String getThumbnail(int w, int h, int q) {
        return this.getThumbnail(w, h, q, true);
    }

    public String getThumbnail(int w, int h) {
        return this.getThumbnail(w, h, 70);
    }

    public String getThumbnail(int w, int h, int q, boolean isCropped) {
        String[] sizePlaceHolders = new String[]{"$WIDTH", "$HEIGHT", "$QUALITY"};
        String[] dims = new String[]{Integer.toString(w), Integer.toString(h), Integer.toString(q)};
        if (this.getHasThumbs()) {
            return StringUtils.replaceEach((String)this.thumbs.get(0), (String[])sizePlaceHolders, (String[])dims);
        }
        if (this.highlightThumbs != null && this.highlightThumbs.size() > 0) {
            return StringUtils.replaceEach((String)this.highlightThumbs.get(0), (String[])sizePlaceHolders, (String[])dims);
        }
        return "http://www.sapo.pt/pt/img/icon_placeholder_image.svg";
    }

    public String getHighlightThumbnail(int w, int h, int q, boolean isCropped) {
        if (this.getHasHighlightThumbs()) {
            String[] sizePlaceHolders = new String[]{"$WIDTH", "$HEIGHT", "$QUALITY"};
            String[] dims = new String[]{Integer.toString(w), Integer.toString(h), Integer.toString(q)};
            return StringUtils.replaceEach((String)this.highlightThumbs.get(0), (String[])sizePlaceHolders, (String[])dims);
        }
        return this.getThumbnail(w, h, q, isCropped);
    }

    public boolean getHasHighlightThumbs() {
        if (this.highlightThumbs == null) {
            return false;
        }
        return this.highlightThumbs.size() > 0;
    }

    public List<String> getThumbs() {
        return this.thumbs;
    }

    public List<String> getHighlightThumbs() {
        return this.highlightThumbs;
    }

    public String getTitle() {
        return this.title;
    }

    public Set<String> getTopics() {
        return this.topics;
    }

    public List<RelatedVideo> getRelatedVideos() {
        if (this.relatedVideos != null) {
            return this.relatedVideos;
        }
        return Collections.emptyList();
    }

    public String getUrl() {
        return this.url;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.slug == null ? 0 : this.slug.hashCode());
        return result;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    public void setFmtPubDate(String fmtDate) {
        this.fmtDate = fmtDate;
    }

    public void setHighlightImages(Set<String> highlightImages) {
        this.highlightImages = highlightImages;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setHostIcon(String hostIcon) {
        this.hostIcon = hostIcon;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    public void setNextByCategory(String next) {
        this.nextByCategory = next;
    }

    public void setNextByPosition(String nextByPosition) {
        this.nextByPosition = nextByPosition;
    }

    public void setNextByLatestHost(String nextByHost) {
        this.nextByLatestHost = nextByHost;
    }

    public void setNextByHost(String nextByHost) {
        this.nextByHost = nextByHost;
    }

    public void setImages(Set<String> images) {
        this.images = images;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPubDate(Date pubDate) {
        this.pubDate = pubDate;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void setSections(Set<String> sections) {
        this.sections = sections;
    }

    public void setSimilarItems(List<NewsItem> similarItems) {
        this.similarItems = similarItems;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public void setThumbs(List<String> thumbs) {
        this.thumbs = thumbs;
    }

    public void setHighlighthumbs(List<String> highlightThumbs) {
        this.highlightThumbs = highlightThumbs;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setWordCount(int wordCount) {
        this.wordCount = wordCount;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceName() {
        if (Host.getSourceName(this.host) != null) {
            return Host.getSourceName(this.host);
        }
        return this.sourceName;
    }

    public final boolean isContentAllowed() {
        if (this.getHost().equals("www.publico.pt")) {
            Date lastDay = new Date(new Date().getTime() - 86400000L);
            return this.getChangeDate().after(lastDay);
        }
        return Host.isFullContentAllowed(this.getHost());
    }

    public void setRelatedVideos(List<RelatedVideo> vids) {
        this.relatedVideos = vids;
    }

    public boolean isVideoPreProcessed() {
        return this.isVidPreProc;
    }

    public void setVideoPreProcessed(boolean isVidPreProc) {
        this.isVidPreProc = isVidPreProc;
    }

    public void setRequiresPayment(boolean requiresPayment) {
        this.requiresPayment = requiresPayment;
    }

    public boolean getRequiresPayment() {
        return this.requiresPayment;
    }

    public void setCleanBody(String clean_body) {
        this.clean_body = clean_body;
    }

    public void setImageGallery(ImageGallery imageGallery) {
        this.imageGallery = imageGallery;
        this.hasImageGallery = true;
    }

    public ImageGallery getImageGallery() {
        return this.imageGallery;
    }

    public boolean getHasImageGallery() {
        return this.hasImageGallery;
    }

    public void setVideos(Set<String> videos) {
        this.videos = videos.stream().filter(v -> v.contains("videos.sapo.pt")).collect(Collectors.toSet());
    }

    public boolean getHasVideos() {
        return this.videos.size() > 0;
    }

    public boolean getHasRelatedVideos() {
        return this.getRelatedVideos().size() > 0;
    }

    public String getVideoUrl() {
        if (this.getHasVideos()) {
            String vurl = (String)this.videos.stream().findFirst().get();
            if (StringUtils.startsWith((CharSequence)vurl, (CharSequence)"http://videos.sa")) {
                vurl = StringUtils.replace((String)vurl, (String)"http://videos.sa", (String)"http://rd3.videos.sa");
            }
            return StringUtils.replace((String)vurl, (String)"/mov/1", (String)"");
        }
        return "0000000000000000";
    }

    public String getVideo() {
        if (this.getHasVideos()) {
            String vurl = (String)this.videos.stream().findFirst().get();
            Matcher tagmatch = link.matcher(vurl);
            if (tagmatch.find()) {
                String match = tagmatch.group();
                vurl = StringUtils.substringAfter((String)match, (String)"file=");
            }
            if (StringUtils.startsWith((CharSequence)vurl, (CharSequence)"http://videos.sapo")) {
                vurl = StringUtils.replace((String)vurl, (String)"http://videos.sapo", (String)"http://rd3.videos.sapo");
            }
            if (!StringUtils.endsWith((CharSequence)vurl, (CharSequence)"/mov/1")) {
                vurl = String.format("%s/mov/1", vurl);
            }
            return vurl;
        }
        return "";
    }

    public boolean getShowAuthor() {
        return StringUtils.isNotBlank((CharSequence)this.getAuthor()) && !"--".equals(this.getAuthor());
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean getShowVideos() {
        return this.getHasVideos() && this.getHost().contains(".pt");
    }

    public boolean getShowRelatedVideos() {
        return this.getHasRelatedVideos() && this.getHost().contains(".pt");
    }

    public void setSourceType(String source_type) {
        this.source_type = source_type;
    }

    public String getSourceType() {
        return this.source_type;
    }

    public void setSocialShares(Map<String, Integer> social_shares) {
        if (social_shares == null) {
            this.social_shares = Collections.emptyMap();
            this.socialActionCount = 0;
        } else {
            this.social_shares = social_shares;
            this.socialActionCount = social_shares.values().stream().filter(n -> n > 0).map(i -> (int)i).reduce(0, (accumulator, _item) -> accumulator + _item);
        }
    }

    public void setSocialActionCount(int scount) {
        this.socialActionCount = scount;
    }

    public Map<String, Integer> getSocialShares() {
        return this.social_shares;
    }

    public Map<String, Dimensions> getImageDimensions() {
        return this.imageDimensions;
    }

    public Dimensions getImageDimensions(String url) {
        if (this.imageDimensions == null) {
            return null;
        }
        return this.imageDimensions.get(url);
    }

    public String getImageCredits(String url) {
        if (this.imageDimensions == null) {
            return null;
        }
        String xpto = this.imageCredits.get(url);
        if (xpto != null) {
            return xpto;
        }
        String epic = ThumbsEpic.create(url);
        String thumb_img = String.format("http://thumbs.web.sapo.io/?epic=%s&crop=center&tv=2&errorpic=transparent&delay_optim=1&W=$WIDTH&H=$HEIGHT&Q=$QUALITY&bgcolor=ffffff", epic);
        return this.imageCredits.get(thumb_img);
    }

    public String getImageCredit() {
        String url = this.getThumbnail(450, 253, 70);
        if (this.imageDimensions == null) {
            return null;
        }
        String xpto = this.imageCredits.get(url);
        if (xpto != null) {
            return xpto;
        }
        String epic = ThumbsEpic.create(url);
        String thumb_img = String.format("http://thumbs.web.sapo.io/?epic=%s&crop=center&tv=2&errorpic=transparent&delay_optim=1&W=%s&H=%s&Q=%s&bgcolor=ffffff", epic, 450, 253, 70);
        return this.imageCredits.get(thumb_img);
    }

    public boolean isImageBigger(String url, int width, int height) {
        Dimensions dim = this.getImageDimensions(url);
        if (dim == null) {
            return true;
        }
        return dim.getHeight() >= height && dim.getWidth() >= width;
    }

    public void setImageDimensions(Map<String, Dimensions> imageDimensions) {
        this.imageDimensions = imageDimensions;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getEditorialTitle() {
        return this.editorialTitle;
    }

    public void setEditorialTitle(String editorialTitle) {
        this.editorialTitle = editorialTitle;
    }

    public String getEditorialLead() {
        return this.editorialLead;
    }

    public void setEditorialLead(String editorialLead) {
        this.editorialLead = editorialLead;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String toString() {
        return "NewsItem [url=" + this.url + ", host=" + this.host + ", title=" + this.title + ", editorialTitle=" + this.editorialTitle + ", editorialLead=" + this.editorialLead + ", lead=" + this.lead + ", label=" + this.label + ", body=" + this.body + ", categories=" + this.categories + ", topics=" + this.topics + ", sections=" + this.sections + ", images=" + this.images + ", highlightImages=" + this.highlightImages + ", thumbs=" + this.thumbs + ", highlightThumbs=" + this.highlightThumbs + ", similarItems=" + this.similarItems + ", isValid=" + this.isValid + ", wordCount=" + this.wordCount + ", socialActionCount=" + this.socialActionCount + ", slug=" + this.slug + ", score=" + this.score + ", pubDate=" + this.pubDate + ", changeDate=" + this.changeDate + ", fmtDate=" + this.fmtDate + ", imageDimensions=" + this.imageDimensions + ", imageCredits=" + this.imageCredits + ", hostIcon=" + this.hostIcon + ", nextByCategory=" + this.nextByCategory + ", nextByPosition=" + this.nextByPosition + ", nextByHost=" + this.nextByHost + ", nextByLatestHost=" + this.nextByLatestHost + ", keywords=" + this.keywords + ", position=" + this.position + ", clean_body=" + this.clean_body + ", sourceName=" + this.sourceName + ", relatedVideos=" + this.relatedVideos + ", isVidPreProc=" + this.isVidPreProc + ", requiresPayment=" + this.requiresPayment + ", imageGallery=" + this.imageGallery + ", hasImageGallery=" + this.hasImageGallery + ", videos=" + this.videos + ", author=" + this.author + ", source_type=" + this.source_type + ", social_shares=" + this.social_shares + "]";
    }
}

