/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.api;

public class Term {
    private final String word;
    private final double idf;
    private double termCount;

    public Term(String word, double idf) {
        this.word = word;
        this.idf = idf;
        this.termCount = 1.0;
    }

    public String getWord() {
        return this.word;
    }

    public double getIdf() {
        return this.idf;
    }

    public double getTf() {
        return Math.sqrt(this.termCount);
    }

    public double getTfIdf() {
        return this.getTf() * this.getIdf();
    }

    public void incrementCount() {
        this.termCount += 1.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.word == null ? 0 : this.word.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        return !(this.word == null ? other.word != null : !this.word.equals(other.word));
    }

    public String toString() {
        return String.format("Term [word=%s, idf=%s, termCount=%s, tf=%s, tfidf=%s]", this.word, this.idf, this.termCount, this.getTf(), this.getTfIdf());
    }
}

