/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.tools;

import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.tools.Host;
import pt.sapo.hp24.tools.ThumbsEpic;

public class Articles {
    private static Logger log = LoggerFactory.getLogger(Articles.class);

    public static boolean isOpinion(NewsItem ni) {
        try {
            return ni.getSections().contains("opiniao");
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String headlineThumb(NewsItem ni, int w, int h, int q) {
        return Articles.getThumb(ni, w, h, q);
    }

    public static String getThumb(String url, int w, int h, int q) {
        return Articles.getThumb(url, w, h, q, false);
    }

    public static String getThumb(String url, int w, int h, int q, boolean isTransparentErrorPics) {
        return Articles.getThumb(url, w, h, q, isTransparentErrorPics, "ffffff");
    }

    public static String getThumb(String url, int w, int h, int q, boolean isTransparentErrorPics, String bgColor) {
        String epic = ThumbsEpic.create(url);
        ArrayList<String> lstArgs = new ArrayList<String>();
        if (isTransparentErrorPics) {
            lstArgs.add("errorpic=transparent");
        }
        if (bgColor != null && !bgColor.isEmpty()) {
            lstArgs.add(String.format("bgColor=%s", bgColor));
        }
        StringBuilder sb = new StringBuilder();
        for (String s : lstArgs) {
            sb.append("&");
            sb.append(s);
        }
        String t = String.format("http://thumbs.web.sapo.io/?epic=%s&tv=2&W=%s&H=%s&Q=%s&delay_optim=1%s", epic, w, h, q, sb.toString());
        return t;
    }

    public static String getThumb(String url, int w, int q) {
        return Articles.getThumb(url, w, q, "ffffff");
    }

    public static String getThumb(String url, int w, int q, String bgcolor) {
        if (url != null && url.startsWith("http://thumbs.sapo.pt")) {
            return url;
        }
        String epic = ThumbsEpic.create(url);
        String t = String.format("http://thumbs.web.sapo.io/?epic=%s&W=%s&Q=%s&delay_optim=1", epic, w, q);
        return t;
    }

    public static String getThumb(NewsItem ni, int w, int h) {
        return Articles.getThumb(ni, w, h, 70);
    }

    public static String getThumb(NewsItem ni, int w, int h, int q) {
        return Articles.getThumb(ni, w, h, q, "ffffff");
    }

    public static String getThumb(NewsItem ni, int w, int h, int q, String bgcolor) {
        if (ni.getHasThumbs() && ni.isImageBigger(ni.getThumbs().get(0), 100, 100)) {
            return ni.getThumbnail(w, h, q);
        }
        if (ni.getHasHighlightThumbs()) {
            Set<String> lstImg = ni.getHighlightImages();
            String photo = (String)lstImg.toArray()[0];
            String photoThumb = String.format("http://thumbs.web.sapo.io/?epic=%s&crop=face&tv=2&errorpic=transparent&delay_optim=1&W=$WIDTH&H=$HEIGHT&Q=$QUALITY&bgcolor=%s", ThumbsEpic.create(photo), bgcolor);
            if (photo != null && ni.getHighlightThumbs().get(0).equals(photoThumb)) {
                if (ni.isImageBigger(photo, 100, 100)) {
                    return ni.getHighlightThumbnail(w, h, q, true);
                }
                String defImg = Host.defaultImage(ni.getHost());
                if (defImg != null) {
                    return Articles.getThumb(defImg, w, h, q);
                }
                log.warn("No default image for host: {}", (Object)ni.getHost());
                return Articles.getThumb("http://www.sapo.pt/pt/img/icon_placeholder_image.svg", w, h, q, true);
            }
            return ni.getHighlightThumbnail(w, h, q, true);
        }
        String defImg = Host.defaultImage(ni.getHost());
        if (defImg != null) {
            return Articles.getThumb(defImg, w, h, q);
        }
        log.warn("No default image for host: {}", (Object)ni.getHost());
        return Articles.getThumb("http://www.sapo.pt/pt/img/icon_placeholder_image.svg", w, h, q, true);
    }
}

