/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.tools;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.tools.ThumbsEpic;

public class LinkGetter {
    private static Pattern htmltag = Pattern.compile("<img\\b[^>]*src=\"[^>]*>");
    private static Pattern link = Pattern.compile("src=\"[^>]*>");

    public String getBodyLinksWithThumbUrl(String body) {
        ArrayList<String> linksThumbs = new ArrayList<String>();
        ArrayList<String> linksOrig = new ArrayList<String>();
        Matcher tagmatch = htmltag.matcher(body);
        while (tagmatch.find()) {
            Matcher matcher = link.matcher(tagmatch.group());
            matcher.find();
            String link = matcher.group().replaceFirst("src=\"", "");
            if (!this.valid(link = StringUtils.substringBefore((String)link, (String)"\""))) continue;
            linksThumbs.add(String.format("http://thumbs.web.sapo.io/?epic=%s&W=895&delay_optim=1", ThumbsEpic.create(this.makeAbsolute(body, link))));
            linksOrig.add(link);
        }
        body = StringUtils.replaceEach((String)body, (String[])linksOrig.toArray(new String[linksOrig.size()]), (String[])linksThumbs.toArray(new String[linksThumbs.size()]));
        return body;
    }

    private boolean valid(String s) {
        return !s.matches(".*thumbs.web.sapo.*|javascript:.*|mailto:.*");
    }

    private String makeAbsolute(String url, String link) {
        if (link.matches("http://.*") || link.matches("https://.*")) {
            return link;
        }
        if (link.matches("/.*") && url.matches(".*$[^/]")) {
            return url + "/" + link;
        }
        if (link.matches("[^/].*") && url.matches(".*[^/]")) {
            return url + "/" + link;
        }
        if (link.matches("/.*") && url.matches(".*[/]")) {
            return url + link;
        }
        if (link.matches("/.*") && url.matches(".*[^/]")) {
            return url + link;
        }
        throw new RuntimeException("Cannot make the link absolute. Url: " + url + " Link " + link);
    }

    public void getBodyLinksWithThumbUrl(NewsItem newsItem) {
        String body = newsItem.getBody();
        if (body != null && !body.isEmpty()) {
            newsItem.setBody(this.getBodyLinksWithThumbUrl(body));
        }
    }
}

