/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.classifier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.classifier.ClassLabel;
import pt.sapo.hp24.classifier.SVMFormatter;
import saposvm.svm_train;

public class SVMTool {
    private static Pattern splitter = Pattern.compile(",|;|\\s");

    public static void main(String[] args) {
        SVMTool.generateFile("./train_dump.txt", "./train.dat", true);
        SVMTool.generateFile("./test_dump.txt", "./test.dat", false);
        svm_train t = new svm_train();
        String[] argv = new String[]{"-t", "0", "-b", "1", "train.dat", "classifier.model"};
        try {
            t.run(argv);
        }
        catch (Throwable e) {
            Shutdown.now((Throwable)e);
        }
    }

    public static void generateFile(String inFile, String outFile, boolean isTrain) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(inFile));
            BufferedWriter w = new BufferedWriter(new FileWriter(outFile));
            String line = null;
            while ((line = r.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                String[] parts = StringUtils.splitPreserveAllTokens((String)line, (char)'\t');
                String label = parts[4];
                String host = parts[1];
                String[] text = splitter.split(parts[2]);
                String[] meta = splitter.split(parts[3]);
                String clazz = isTrain ? Integer.toString(ClassLabel.getId(label)) : "0";
                String svmLine = SVMFormatter.getLine(clazz, host, text, meta);
                w.write(svmLine);
                w.write("\n");
            }
            r.close();
            w.flush();
            w.close();
            System.out.printf("Generated file: %s%n", outFile);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static void createModel(List<NewsItem> articles, String outFile) {
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter("./train.dat"));
            for (NewsItem ni : articles) {
                String svmLine = SVMTool.buildSVMLine(ni);
                w.write(svmLine);
                w.write("\n");
            }
            w.flush();
            w.close();
            svm_train t = new svm_train();
            String[] argv = new String[]{"-t", "0", "-b", "1", "./train.dat", outFile};
            t.run(argv);
            System.out.printf("Generated file: %s%n", outFile);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static String buildSVMLine(NewsItem ni) {
        String[] text = splitter.split(ni.getLeadText());
        String[] meta = splitter.split(StringUtils.join((Iterable)ni.getCategories(), (String)",") + StringUtils.join((Iterable)ni.getTopics(), (String)","));
        String svmLine = SVMFormatter.getLine(ni.getSection(), ni.getHost(), text, meta);
        return svmLine;
    }
}

