/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.concurrent.CustomExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.NetAction;
import pt.sapo.hp24.api.NewsDb;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.db.Broker;
import pt.sapo.hp24.db.NewsDbBuilder;
import pt.sapo.hp24.db.tools.SiteCacheFiller;
import pt.sapo.hp24.db.tools.UploadTo;

public class DbBuilder {
    private static Logger log = LoggerFactory.getLogger(DbBuilder.class);
    private static final ScheduledExecutorService shed_exec = CustomExecutors.newScheduledThreadPool((int)1, (String)"sched-exec");
    private static Broker broker = new Broker();
    static List<String> frontends = new ArrayList<String>();
    static final String environment;
    public static Object lock_1;
    private static final String QUEUE_DB;
    private static final String QUEUE_INDEXER = "/sapo/24h/indexer/updated";

    public static void main(String[] args) {
        Runnable ardinadb_builder = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                log.info("#1Inicio do updatedb");
                List<NewsItem> docs = DbBuilder.buildAndUpload();
                log.info("#1Fim do updatedb");
                log.info("Total time: {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
            }
        };
        try {
            broker.consume(NetAction.DestinationType.TOPIC, QUEUE_INDEXER);
            broker.consumeWarmerCache(NetAction.DestinationType.TOPIC, QUEUE_DB);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        shed_exec.scheduleWithFixedDelay(ardinadb_builder, 0L, 5L, TimeUnit.MINUTES);
    }

    /*
     * Exception decompiling
     */
    public static synchronized List<NewsItem> getAllDocs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static synchronized NewsDb getNewsDb() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NewsItem> buildAndUpload() {
        List docs = null;
        File toUpload = null;
        try {
            Iterator<String> iterator = lock_1;
            synchronized (iterator) {
                NewsDbBuilder.build();
                Path path = Paths.get("./news.db", new String[0]);
                byte[] data = Files.readAllBytes(path);
                NewsDb.build((InputStream)new FileInputStream("./news.db"));
                toUpload = new File(path.toUri());
            }
            block7: for (String host : frontends) {
                for (int i = 3; i > 0; --i) {
                    try {
                        if (UploadTo.chunked(String.format("http://%s/updatedb", host), toUpload) != 200) continue;
                        continue block7;
                    }
                    catch (Throwable t) {
                        log.error(t.toString());
                        log.error("Sleeping {} milliseconds", (Object)(3000 - 1000 / i));
                        Thread.sleep(3000 - 1000 / i);
                    }
                }
            }
            docs = NewsDb.getAllArticles();
            docs.addAll(NewsDb.getAllHeadlines());
            docs.addAll(NewsDb.getAllEditorial());
            docs.addAll(NewsDb.getAllLatestNews());
            docs.addAll(NewsDb.getAllLusaLatestNews());
            long epoch = System.currentTimeMillis() / 1000L;
            String date = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(epoch * 1000L));
            for (NewsItem doc : docs) {
                String host = doc.getHost();
                if (!StringUtils.contains((CharSequence)host, (CharSequence)"www.sapo.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"desporto.sapo.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"tek.sapo.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"cinema.sapo.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.tsf.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.sol.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.ionline.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.jn.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.dn.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.cmjornal.xl.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.record.xl.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"diariodigital.sapo.pt") && !StringUtils.contains((CharSequence)host, (CharSequence)"www.ojogo.pt")) continue;
                String body = doc.getBody() != null && !doc.getBody().isEmpty() ? "true" : "false";
                System.out.println("###i### " + date + ";" + doc.getHost() + ";" + doc.getUrl() + ";" + "-" + ";" + body + ";" + doc.getHasImageGallery() + ";" + doc.getHasVideos());
            }
            broker.publish(NetAction.DestinationType.TOPIC, QUEUE_DB, "-");
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NewsItem> buildEditorialAndUpload() {
        List docs = null;
        File toUpload = null;
        try {
            Iterator<String> iterator = lock_1;
            synchronized (iterator) {
                NewsDbBuilder.buildEditorial();
                Path path = Paths.get("./news.db", new String[0]);
                NewsDb.build((InputStream)new FileInputStream("./news.db"));
                toUpload = new File(path.toUri());
            }
            block7: for (String host : frontends) {
                for (int i = 3; i > 0; --i) {
                    try {
                        if (UploadTo.chunked(String.format("http://%s/updatedb", host), toUpload) != 200) continue;
                        continue block7;
                    }
                    catch (Throwable t) {
                        log.error(t.toString());
                        log.error("Sleeping {} milliseconds", (Object)(3000 - 1000 / i));
                        Thread.sleep(3000 - 1000 / i);
                    }
                }
            }
            docs = NewsDb.getAllArticles();
            docs.addAll(NewsDb.getAllHeadlines());
            docs.addAll(NewsDb.getAllEditorial());
            docs.addAll(NewsDb.getAllLatestNews());
            docs.addAll(NewsDb.getAllLusaLatestNews());
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
        return docs;
    }

    public static void CacheFiller(List<NewsItem> docs) {
        try {
            SiteCacheFiller.fill("24.sapo.pt", docs, frontends);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }

    static {
        lock_1 = new int[1];
        environment = System.getProperty("environment", "staging");
        System.out.println("loading settings for " + environment);
        if (environment.equals("production")) {
            frontends.add("10.135.32.151:8082");
            frontends.add("10.135.32.152:8082");
            frontends.add("10.135.32.153:8082");
            frontends.add("10.135.32.154:8082");
            frontends.add("10.135.32.155:8082");
        } else {
            frontends.add("10.184.244.197:8080");
            frontends.add("10.184.244.204:8080");
        }
        QUEUE_DB = String.format("/sapo/24h/db/cache/%s", environment);
    }
}

