/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.concurrent.CustomExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hp24.api.Image;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.db.tools.DevNullResponseHandler;
import pt.sapo.hp24.db.tools.HttpClientBuilder;
import pt.sapo.hp24.tools.Articles;

public class SiteCacheFiller {
    private static Logger log = LoggerFactory.getLogger(SiteCacheFiller.class);
    private static final SiteCacheFiller instance = new SiteCacheFiller();
    private static final DevNullResponseHandler dev_null_handler = new DevNullResponseHandler();
    private CloseableHttpClient httpclient = HttpClientBuilder.get();

    private SiteCacheFiller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill(String hostname, List<NewsItem> articles, List<String> frontends) {
        ThreadPoolExecutor exec = CustomExecutors.newThreadPool((int)24, (String)"cache-warmer-exec");
        try {
            log.info("Fill cache for {} articles", (Object)articles.size());
            List<String> urls = SiteCacheFiller.buildUrlList(frontends, articles);
            CountDownLatch latch_pages = new CountDownLatch(urls.size());
            for (String url : urls) {
                SiteCacheFiller.warmArticles(exec, latch_pages, hostname, url);
            }
            SiteCacheFiller.wait(latch_pages);
            log.info("Article cache is done");
            List<String> thumb_urls = SiteCacheFiller.buildImageUrlList(articles);
            Collections.shuffle(thumb_urls);
            CountDownLatch latch_thumbs = new CountDownLatch(thumb_urls.size());
            log.info("Fetch {} thumbs", (Object)thumb_urls.size());
            long start = System.currentTimeMillis();
            int nrCalls = 0;
            for (String thumb_url : thumb_urls) {
                if (nrCalls++ % 19 == 0) {
                    long now = System.currentTimeMillis();
                    long delta = now - start;
                    if (delta < 1000L) {
                        log.debug("i: {}, delta: {}", (Object)nrCalls, (Object)delta);
                        Thread.sleep(1100L - delta);
                    } else {
                        Thread.sleep(1000L);
                    }
                    start = now;
                }
                SiteCacheFiller.warmImages(exec, latch_thumbs, thumb_url);
            }
            SiteCacheFiller.wait(latch_thumbs);
            log.info("Thumb fetching is done");
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
        finally {
            exec.shutdown();
            log.info("Site cache is done");
        }
    }

    private static void wait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private static List<String> buildUrlList(List<String> frontends, List<NewsItem> articles) {
        ArrayList<String> lst = new ArrayList<String>();
        for (String frontend : frontends) {
            lst.add(String.format("http://%s/", frontend));
            lst.add(String.format("http://%s/desporto", frontend));
            lst.add(String.format("http://%s/economia", frontend));
            lst.add(String.format("http://%s/vida", frontend));
            lst.add(String.format("http://%s/actualidade", frontend));
            lst.add(String.format("http://%s/tecnologia", frontend));
            lst.add(String.format("http://%s/opiniao", frontend));
            for (NewsItem ni : articles) {
                lst.add(String.format("http://%s/article/%s", frontend, ni.getSlug()));
                lst.add(String.format("http://%s/async_article/%s", frontend, ni.getSlug()));
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void warmImages(ExecutorService exec, CountDownLatch latch, String thumb_url) {
        try {
            SiteCacheFiller.get(thumb_url, dev_null_handler);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error("thumb_url: {}", (Object)thumb_url);
            log.error(r.getMessage(), r);
        }
        finally {
            latch.countDown();
        }
    }

    private static List<String> buildImageUrlList(List<NewsItem> articles) {
        ArrayList<String> thumb_urls = new ArrayList<String>();
        for (NewsItem ni : articles) {
            if (ni.getCategories().contains("opini\u00e3o")) {
                SiteCacheFiller.append(thumb_urls, ni, 190, 190);
                SiteCacheFiller.append(thumb_urls, ni, 240, 240);
            } else {
                SiteCacheFiller.append(thumb_urls, ni, 960, 540);
                SiteCacheFiller.append(thumb_urls, ni, 640, 360);
                SiteCacheFiller.append(thumb_urls, ni, 480, 270);
                SiteCacheFiller.append(thumb_urls, ni, 320, 240);
                SiteCacheFiller.append(thumb_urls, ni, 640, 480);
            }
            if (!ni.getHasImageGallery()) continue;
            Set imgs = ni.getImageGallery().getImages();
            for (Image img : imgs) {
                SiteCacheFiller.append(thumb_urls, img, 320, 240);
            }
        }
        return thumb_urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void warmArticles(ExecutorService exec, CountDownLatch latch, String hostname, String url) {
        try {
            HttpGet httpget = new HttpGet(url);
            httpget.setHeader("Host", hostname);
            httpget.setHeader("User-Agent", "CACHE-WARM");
            httpget.setHeader("Accept-Encoding", "gzip");
            SiteCacheFiller.get(httpget, dev_null_handler);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
        finally {
            latch.countDown();
        }
    }

    public static void get(HttpGet httpget, DevNullResponseHandler dev_null) {
        instance.doHttpGet(httpget, dev_null);
    }

    public static void get(String api_url, DevNullResponseHandler dev_null) {
        instance.doHttpGet(api_url, dev_null);
    }

    private void doHttpGet(HttpGet httpget, DevNullResponseHandler dev_null) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)dev_null, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }

    private void doHttpGet(String api_url, DevNullResponseHandler dev_null) {
        HttpGet httpget = new HttpGet(api_url);
        BasicHttpContext context = new BasicHttpContext();
        try {
            this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)dev_null, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error("url: {}, ErrorAnalyser: {}", (Object)api_url, (Object)r.getMessage());
        }
    }

    private static void append(List<String> thumb_urls, NewsItem ni, int w, int h) {
        String u = ni.getThumbnail(w, h);
        SiteCacheFiller.doAppend(thumb_urls, u);
    }

    private static void append(List<String> thumb_urls, Image img, int w, int h) {
        String u = Articles.getThumb((String)img.getUrl(), (int)w, (int)h, (int)70);
        SiteCacheFiller.doAppend(thumb_urls, u);
    }

    private static void doAppend(List<String> thumb_urls, String u) {
        if (u.contains("thumbs.web.sapo.io")) {
            thumb_urls.add(u);
        }
    }
}

