/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.classifier;

import java.io.IOException;
import java.util.StringTokenizer;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_print_interface;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import pt.sapo.hp24.classifier.ClassLabel;
import pt.sapo.hp24.classifier.PredictedSection;

class SVMClassifier {
    private static final SVMClassifier instance = new SVMClassifier();
    private static svm_print_interface svm_print_stdout;
    private static svm_print_interface svm_print_string;
    private svm_model model;
    private int svm_type;
    private int nr_class;
    private int[] labels;

    static void info(String s) {
        svm_print_string.print(s);
    }

    private static double atof(String s) {
        return Double.valueOf(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    public SVMClassifier() {
        try {
            this.model = svm.svm_load_model((String)"./classifier.model");
            this.svm_type = svm.svm_get_svm_type((svm_model)this.model);
            this.nr_class = svm.svm_get_nr_class((svm_model)this.model);
            this.labels = new int[this.nr_class];
            svm.svm_get_labels((svm_model)this.model, (int[])this.labels);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    private PredictedSection doPredict(String line, int predict_probability) throws IOException {
        if (StringUtils.isBlank((CharSequence)line)) {
            return new PredictedSection("actualidade", 1.0);
        }
        double[] prob_estimates = new double[this.nr_class];
        StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
        double target = SVMClassifier.atof(st.nextToken());
        int m = st.countTokens() / 2;
        svm_node[] x = new svm_node[m];
        for (int j = 0; j < m; ++j) {
            x[j] = new svm_node();
            x[j].index = SVMClassifier.atoi(st.nextToken());
            x[j].value = SVMClassifier.atof(st.nextToken());
        }
        double v = svm.svm_predict_probability((svm_model)this.model, (svm_node[])x, (double[])prob_estimates);
        int classId = new Double(v).intValue();
        String label = ClassLabel.getLabel(classId);
        double maxProbability = Double.MIN_VALUE;
        for (int j = 0; j < this.nr_class; ++j) {
            maxProbability = Math.max(prob_estimates[j], maxProbability);
        }
        return new PredictedSection(label, maxProbability);
    }

    public static PredictedSection classify(String line) {
        try {
            return instance.doPredict(line, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new PredictedSection("actualidade", 1.0);
        }
    }

    static {
        svm_print_string = svm_print_stdout = new svm_print_interface(){

            public void print(String s) {
                System.out.print(s);
            }
        };
    }
}

