/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db.tools;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.util.EntityUtils;
import pt.sapo.hp24.db.tools.JsonResponseHandler;

public class JsonPResponseHandler
extends JsonResponseHandler {
    public JsonPResponseHandler(String net, String jsonPath) {
        super(net, jsonPath);
    }

    @Override
    public Integer handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String jsonp = EntityUtils.toString((HttpEntity)entity);
                String json = StringUtils.substringBetween((String)jsonp, (String)"(", (String)")");
                JsonNode rootNode = mapper.readTree(json);
                int count = rootNode.at(this.getJsonPath()).asInt(0);
                return count;
            }
            return 0;
        }
        throw new ClientProtocolException("Unexpected response status from " + this.getNet() + ". Status: " + status);
    }
}

