/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.caudexorigo.text.HtmlStripper;
import pt.sapo.hp24.api.Dimensions;
import pt.sapo.hp24.api.ImageGalleries;
import pt.sapo.hp24.api.ImageGallery;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.db.tools.JsonConverter;
import pt.sapo.hp24.db.tools.Slug;
import pt.sapo.hp24.tools.DateFmt;
import pt.sapo.hp24.tools.Host;
import pt.sapo.hp24.tools.Text;
import pt.sapo.hp24.tools.ThumbsEpic;
import pt.sapo.hp24.tools.Url;

public class NewsItemBuilder {
    private static final String[] invalid_photo_tokens = new String[]{"imgP.gif", "_default", "_icon", "user_", "/logo", "_logo", "logo_", "img_100x100$", "de-og.jpg", "_devices", "_registered", "expresso_200px.jpg", "1x1.gif", "blank.gif"};
    private static final Pattern rr_small = Pattern.compile("_\\d\\d\\dx\\d\\d\\d\\.jpg", 2);
    private static final String[] remove_page_params = new String[]{"&page=-1", "?page=-1"};
    private static final String[] remove_page_values = new String[]{"", ""};
    private static final JsonConverter<ImageGalleries> omapper = new JsonConverter<ImageGalleries>(ImageGalleries.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private NewsItem ni;

    public NewsItemBuilder(SolrDocument sdoc) {
        this.init(sdoc, true);
    }

    public NewsItemBuilder(SolrDocument sdoc, boolean discardInvalid) {
        this.init(sdoc, discardInvalid);
    }

    private void init(SolrDocument sdoc, boolean discardInvalid) {
        Iterator iterator;
        String url = (String)sdoc.getFieldValue("Url");
        if (url.contains("exameinformatica")) {
            url = StringUtils.substringBefore((String)url, (String)";jsessionid");
        }
        url = StringUtils.replaceEach((String)url, (String[])remove_page_params, (String[])remove_page_values);
        String host = (String)sdoc.getFieldValue("Hostname");
        String source = (String)sdoc.getFieldValue("Source");
        String source_type = (String)sdoc.getFieldValue("SourceType");
        this.ni = new NewsItem(url);
        String lead = (String)sdoc.getFieldValue("Lead");
        String html_body = (String)sdoc.getFieldValue("Body");
        String clean_body = HtmlStripper.strip((String)html_body);
        String title = (String)sdoc.getFieldValue("Title");
        String author = (String)sdoc.getFieldValue("Author");
        if (StringUtils.isBlank((CharSequence)title)) {
            System.out.println("NewsItemBuilder.init: empty title for: " + url);
            return;
        }
        if (sdoc.getFieldValue("Meta_S_Backoffice_Title") != null) {
            this.ni.setEditorialTitle((String)sdoc.getFieldValue("Meta_S_Backoffice_Title"));
        }
        this.ni.setValid(this.isValidBody(title, clean_body));
        Date pubDate = (Date)sdoc.getFieldValue("PublishDate");
        Date changeDate = (Date)sdoc.getFieldValue("ChangedDate");
        String searchSlug = (String)sdoc.getFieldValue("Slug");
        String slug = Slug.create(host, searchSlug, title, pubDate, this.ni.getUrl());
        int wordCount = StringUtils.countMatches((CharSequence)clean_body, (CharSequence)" ") + 1;
        if (pubDate != null) {
            String fmtDate = DateFmt.get((Date)pubDate);
            this.ni.setPubDate(pubDate);
            this.ni.setFmtPubDate(fmtDate);
        }
        if (changeDate != null) {
            this.ni.setChangeDate(changeDate);
        }
        this.ni.setBody(html_body);
        this.ni.setCleanBody(clean_body);
        this.ni.setTitle(title);
        this.ni.setAuthor(author);
        this.ni.setSlug(slug);
        this.ni.setWordCount(wordCount);
        this.ni.setSourceName(source);
        this.ni.setHost(host);
        this.ni.setHostIcon(Host.icon((String)host));
        this.ni.setSourceType(source_type);
        this.ni.setLead(lead);
        HashSet<String> sane_categories = new HashSet<String>();
        HashSet<String> sane_topics = new HashSet<String>();
        this.sanitizeCategories(sdoc, sane_categories, "Categories");
        this.sanitizeCategories(sdoc, sane_topics, "Tags");
        String host_category = Host.category((String)host);
        if (host_category != null && sane_categories.isEmpty()) {
            sane_categories.add(host_category);
        }
        if (url.contains("/opiniao")) {
            sane_categories.add("opini\u00e3o");
        }
        this.ni.addCategories(sane_categories);
        this.ni.addTopics(sane_topics);
        Set<String> saneContentImages = this.getSanePhotos(host, sdoc.getFieldValues("Images"));
        Set<String> saneHighlightImages = this.getSanePhotos(host, sdoc.getFieldValues("HighlightImages"));
        String ni_images_dimensions = null;
        if (sdoc.getFieldValue("MultiMeta_S_Image_Dimensions") != null && (iterator = sdoc.getFieldValues("MultiMeta_S_Image_Dimensions").iterator()).hasNext()) {
            Object ocat = iterator.next();
            ni_images_dimensions = (String)ocat;
        }
        if (sdoc.getFieldValue("Meta_S_Label") != null) {
            this.ni.setLabel((String)sdoc.getFieldValue("Meta_S_Label"));
        }
        if (sdoc.getFieldValue("Meta_S_Image_Credits") != null) {
            String imageCredits = (String)sdoc.getFieldValue("Meta_S_Image_Credits");
            Map map = new HashMap();
            try {
                map = (Map)mapper.readValue(imageCredits, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
            catch (IOException e) {
                // empty catch block
            }
            this.ni.setImageCredits(map);
        }
        Map map = new HashMap();
        try {
            if (ni_images_dimensions != null) {
                map = (Map)mapper.readValue(ni_images_dimensions, (TypeReference)new TypeReference<HashMap<String, Dimensions>>(){});
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        this.ni.setImageDimensions(map);
        this.ni.setImages(saneContentImages);
        List<String> thumbs = this.getThumbs(saneContentImages);
        this.ni.setThumbs(thumbs);
        this.ni.setHighlightImages(saneHighlightImages);
        List<String> highlightThumbs = this.getThumbs(saneHighlightImages);
        this.ni.setHighlighthumbs(highlightThumbs);
        Object oReqPay = sdoc.getFieldValue("RequiresPayment");
        boolean requiresPayment = false;
        if (oReqPay != null) {
            requiresPayment = Boolean.parseBoolean((String)oReqPay);
        }
        this.ni.setRequiresPayment(requiresPayment);
        String simgGal = (String)sdoc.getFieldValue("ImageGalleries");
        if (simgGal != null && !simgGal.equals("null")) {
            try {
                ImageGalleries imgGalleries = omapper.fromJson(simgGal);
                if (imgGalleries != null && imgGalleries.size() > 0) {
                    this.ni.setImageGallery((ImageGallery)imgGalleries.get(0));
                }
            }
            catch (Throwable t) {
                System.out.println("Error parsing ImageGalleries : " + simgGal);
                t.printStackTrace();
            }
        }
        HashSet<String> videos = new HashSet<String>();
        this.getMultiValuedField(sdoc, videos, "Videos");
        this.ni.setVideos(videos);
    }

    private List<String> getThumbs(Set<String> photos) {
        ArrayList<String> thumbs = new ArrayList<String>();
        for (String photo : photos) {
            String epic = ThumbsEpic.create((String)photo);
            String thumb_img = String.format("http://thumbs.web.sapo.io/?epic=%s&crop=face&tv=2&errorpic=transparent&delay_optim=1&W=$WIDTH&H=$HEIGHT&Q=$QUALITY&bgcolor=ffffff", epic);
            thumbs.add(thumb_img);
        }
        return thumbs;
    }

    private Set<String> getSanePhotos(String host, Collection<Object> photosHolder) {
        HashSet<String> photoUrls = new HashSet<String>();
        if (photosHolder != null) {
            for (Object ophoto : photosHolder) {
                String sphoto;
                if (ophoto == null || !this.isValidPhotoUrl(sphoto = ophoto.toString())) continue;
                if (sphoto.contains("thumbs.sapo.pt") || sphoto.contains("thumbs.web.sapo.io")) {
                    String[] params;
                    for (String param : params = Url.getUrlParameters((String)sphoto)) {
                        String[] param_parts = StringUtils.split((String)param, (char)'=');
                        String param_name = param_parts[0];
                        if (!"pic".equals(param_name)) continue;
                        sphoto = Url.dec((String[])param_parts);
                    }
                }
                if (sphoto.contains("publico.pt")) {
                    sphoto = Url.sanitizeQSParameters((String)sphoto, (String[])new String[]{"tp", "db"});
                }
                if (sphoto.contains(".rr.pt")) {
                    sphoto = rr_small.matcher(sphoto).replaceAll(".jpg");
                }
                if (sphoto.contains(".rtp.pt")) {
                    sphoto = StringUtils.replace((String)Url.dec((String)sphoto), (String)"/thumb/phpThumb.php?src=", (String)"");
                    sphoto = StringUtils.substringBefore((String)sphoto, (String)"&");
                    sphoto = StringUtils.replace((String)sphoto, (String)"icm//", (String)"icm/");
                }
                if (!StringUtils.isNotBlank((CharSequence)sphoto)) continue;
                photoUrls.add(sphoto);
            }
        }
        if ("observador.pt".equals(host)) {
            this.removeNonFavoriteUrl(photoUrls, "observador.pt/wp-content/");
        } else {
            this.removeNonFavoriteUrl(photoUrls, "cdn.");
        }
        this.removeNonFavoriteUrl(photoUrls, "/users/");
        return photoUrls;
    }

    private void removeNonFavoriteUrl(Set<String> photoUrls, String favoriteToken) {
        boolean hasCdnLink = this.hasToken(photoUrls, favoriteToken);
        if (!hasCdnLink) {
            return;
        }
        HashSet<String> nonTokenUrls = new HashSet<String>();
        for (String sphoto : photoUrls) {
            if (sphoto.contains(favoriteToken)) continue;
            nonTokenUrls.add(sphoto);
        }
        if (photoUrls.size() > nonTokenUrls.size()) {
            for (String u : nonTokenUrls) {
                photoUrls.remove(u);
            }
        }
    }

    private boolean hasToken(Set<String> photoUrls, String token) {
        for (String sphoto : photoUrls) {
            if (!sphoto.contains(token)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidPhotoUrl(String sphoto) {
        for (String token : invalid_photo_tokens) {
            if (StringUtils.contains((CharSequence)sphoto.toLowerCase(), (CharSequence)token)) {
                return false;
            }
            if (sphoto.startsWith("http")) continue;
            return false;
        }
        return true;
    }

    private void getMultiValuedField(SolrDocument sdoc, Set<String> target, String fieldName) {
        if (sdoc.getFieldValues(fieldName) != null) {
            for (Object o : sdoc.getFieldValues(fieldName)) {
                if (o == null) continue;
                target.add(o.toString());
            }
        }
    }

    private void sanitizeCategories(SolrDocument sdoc, Set<String> saneCategories, String fieldName) {
        if (sdoc.getFieldValues(fieldName) != null) {
            for (Object ocat : sdoc.getFieldValues(fieldName)) {
                if (ocat == null) continue;
                saneCategories.add(ocat.toString().trim().toLowerCase());
            }
        }
    }

    public NewsItem get() {
        return this.ni;
    }

    private boolean isValidBody(String title, String body) {
        return !StringUtils.isBlank((CharSequence)title);
    }

    public static void main(String[] args) {
        String body = "No mercado h\u00e1 j\u00e1 quatro meses, o Samsung Gear Fit faz parte de uma fam\u00edlia de smartwatches desenvolvidos pela Samsung. Na verdade, este \u00e9 o mais simples dos rel\u00f3gios que a empresa lan\u00e7ou at\u00e9 agora e \u00e9 dedicado principalmente aos amantes do desporto e do estilo de vida saud\u00e1vel.\nO Gear Fit esteve em an\u00e1lise no Pplware durante algumas semanas e agora apresentamos mais do que uma an\u00e1lise detalhada a este equipamento, pois este artigo serve tamb\u00e9m como um pequeno guia de utiliza\u00e7\u00e3o do Samsung Gear Fit.";
        String lead = Text.getSummary((String)body, (int)250);
        System.out.println(lead);
    }
}

