/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db.tools;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.Shutdown;
import org.caudexorigo.concurrent.CustomExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hp24.db.tools.HttpClientBuilder;
import pt.sapo.hp24.db.tools.JsonPResponseHandler;
import pt.sapo.hp24.db.tools.JsonResponseHandler;
import pt.sapo.hp24.tools.Url;

public class SocialNetworkShareCount {
    private static Logger log = LoggerFactory.getLogger(SocialNetworkShareCount.class);
    private static final SocialNetworkShareCount instance = new SocialNetworkShareCount();
    private CloseableHttpClient httpclient;
    private final ExecutorService exec = CustomExecutors.newThreadPool((int)4, (String)"social-exec");
    private final JsonResponseHandler fb_rsp_handler = new JsonResponseHandler("Facebook", "/0/share_count");
    private final JsonResponseHandler twiter_rsp_handler = new JsonResponseHandler("Twitter", "/count");
    private final JsonResponseHandler gplus_rsp_handler = new JsonResponseHandler("GPlus", "/0/result/metadata/globalCounts/count");
    private final JsonPResponseHandler linkedin_rsp_handler = new JsonPResponseHandler("LinkedIn", "/fCnt");

    private SocialNetworkShareCount() {
        this.httpclient = HttpClientBuilder.get();
    }

    private int fbCount(String eurl) {
        String fb_api_fmt = "http://api.facebook.com/method/links.getStats?format=json&urls=%s";
        String fb_api_url = String.format(fb_api_fmt, eurl);
        return this.doHttpGet(fb_api_url, this.fb_rsp_handler);
    }

    private int twitterCount(String eurl) {
        String twitter_api_fmt = "http://urls.api.twitter.com/1/urls/count.json?url=%s";
        String twitter_api_url = String.format(twitter_api_fmt, eurl);
        return this.doHttpGet(twitter_api_url, this.twiter_rsp_handler);
    }

    private int linkedinCount(String eurl) {
        String linkedin_api_fmt = "https://www.linkedin.com/countserv/count/share?url=%s";
        String linkedin_api_url = String.format(linkedin_api_fmt, eurl);
        return this.doHttpGet(linkedin_api_url, this.linkedin_rsp_handler);
    }

    private int gplusCount(String eurl) {
        String json_request_fmt = "[{\"method\":\"pos.plusones.get\",\"id\":\"p\",\"params\":{\"nolog\":true,\"id\":\"%s\",\"source\":\"widget\",\"userId\":\"@viewer\",\"groupId\":\"@self\"},\"jsonrpc\":\"2.0\",\"key\":\"p\",\"apiVersion\":\"v1\"}]";
        String json_request = String.format(json_request_fmt, eurl);
        return this.doHttpPost("https://clients6.google.com/rpc?key=AIzaSyCKSbrvQasunBoV16zDH9R33D88CeLr9gQ", json_request, this.gplus_rsp_handler);
    }

    private int doHttpGet(String api_url, JsonResponseHandler rsp_handler) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequest((HttpRequestBase)httpget, rsp_handler);
    }

    private int doHttpPost(String api_url, String body, JsonResponseHandler rsp_handler) {
        HttpPost post = new HttpPost(api_url);
        StringEntity json = new StringEntity(body, ContentType.create((String)"application/json", (String)"UTF-8"));
        post.setEntity((HttpEntity)json);
        return this.doHttpRequest((HttpRequestBase)post, rsp_handler);
    }

    private int doHttpRequest(HttpRequestBase httpget, JsonResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            int result = (Integer)this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)rsp_handler, (HttpContext)context);
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to %s - %s%n", rsp_handler.getNet(), r.getMessage()));
            return 0;
        }
    }

    private final int doGetCounts(String url) {
        String eurl = Url.enc((String)url);
        int total_count = 0;
        total_count += this.fbCount(eurl);
        total_count += this.twitterCount(eurl);
        total_count += this.linkedinCount(eurl);
        return total_count += this.gplusCount(url);
    }

    public static final int getCounts(String url) {
        return instance.doGetCounts(url);
    }

    public static final Map<String, Integer> getShareCounts(String url) {
        String eurl = Url.enc((String)url);
        ConcurrentHashMap<String, Integer> result = new ConcurrentHashMap<String, Integer>();
        CountDownLatch latch = new CountDownLatch(3);
        Runnable facebook = () -> {
            result.put("facebook", instance.fbCount(eurl));
            latch.countDown();
        };
        Runnable twitter = () -> {
            result.put("twitter", instance.twitterCount(eurl));
            latch.countDown();
        };
        Runnable gplus = () -> {
            result.put("gplus", instance.gplusCount(url));
            latch.countDown();
        };
        SocialNetworkShareCount.instance.exec.execute(facebook);
        SocialNetworkShareCount.instance.exec.execute(twitter);
        SocialNetworkShareCount.instance.exec.execute(gplus);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        result.put("linkedin", -1);
        result.put("stumbleupon", -1);
        result.put("reddit", -1);
        result.put("pinterest", -1);
        result.put("hi5", -1);
        result.put("habbo", -1);
        result.put("orkut", -1);
        result.put("instagram", -1);
        result.put("netlog", -1);
        result.put("myspace", -1);
        return result;
    }

    public static void main(String[] args) {
        System.out.println(SocialNetworkShareCount.getShareCounts("http://www.sol.pt/noticia/117872"));
        System.out.println(SocialNetworkShareCount.getShareCounts("http://www.publico.pt/sociedade/noticia/pasta-da-colgate-contem-substancia-associada-a-cancro-em-animais-mas-cumpre-regras-europeias-1666301"));
        Shutdown.now();
    }
}

