/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.classifier;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.classifier.SVMClassifier;
import pt.sapo.hp24.classifier.SVMTool;
import pt.sapo.hp24.db.tools.NewsItemBuilder;
import pt.sapo.hp24.db.tools.NewsSolrSearch;
import pt.sapo.hp24.db.tools.Solr;
import pt.sapo.hp24.tools.Host;

public class NaiveClassifier {
    private static final String[] generic_categories = new String[]{"actualidade", "sa\u00fade", "mundo", "globo", "internacional", "outros mundos", "sociedade", "nacional", "local", "seguran\u00e7a", "crime", "justi\u00e7a", "turismo", "europa", "educa\u00e7\u00e3o", "policia", "pa\u00eds", "portugal", "politica", "pol\u00edtica", "lusofonia"};
    private static final String[] opinion_categories = new String[]{"opini\u00e3o", "blogues", "coment\u00e1rio", "editorial", "opiniao"};
    private static final String[] economy_categories = new String[]{"economia", "banca", "finan\u00e7as", "bolsa", "com\u00e9rcio", "mercados", "dinheiro vivo", "banca & finan\u00e7as", "economia/pol\u00edtica"};
    private static final String[] sport_categories = new String[]{"desporto", "modalidades", "futebol", "sele\u00e7\u00e3o", "i liga", "premier league", "la liga", "nba", "ciclismo", "t\u00e9nis", "motores", "fc porto", "sporting", "benfica", "bola branca"};
    private static final String[] scitech_categories = new String[]{"internet", "ci\u00eancia", "tecnologia", "smartphone", "ios", "android", "apple", "inform\u00e1tica", "ciencia-tecnologia"};
    private static final String[] lifestyle_categories = new String[]{"gente", "moda", "lifestyle", "cultura", "cinema", "livros", "artes", "arte", "m\u00fasica", "ins\u00f3lito", "weekend", "cartaz", "roteiros", "famosos", "vida"};
    private static final NaiveClassifier instance = new NaiveClassifier();
    private final Map<String, String[]> cat2section = new LinkedHashMap<String, String[]>();

    private NaiveClassifier() {
        this.cat2section.put("vida", lifestyle_categories);
        this.cat2section.put("tecnologia", scitech_categories);
        this.cat2section.put("economia", economy_categories);
        this.cat2section.put("desporto", sport_categories);
        this.cat2section.put("opiniao", opinion_categories);
        this.cat2section.put("actualidade", generic_categories);
    }

    private void doAssignSections(NewsItem ni, boolean useModel) {
        String[] categories;
        String section;
        Set scategories = ni.getCategories();
        LinkedHashSet<String> sections = new LinkedHashSet<String>();
        Set<Map.Entry<String, String[]>> mappings = this.cat2section.entrySet();
        if (!ni.getUrl().contains(".pt")) {
            String host_category = Host.category((String)ni.getHost());
            if (host_category != null) {
                sections.add(host_category);
            } else {
                sections.add("actualidade");
            }
            ni.addSections(sections);
            return;
        }
        for (Map.Entry<String, String[]> entry : mappings) {
            section = entry.getKey();
            for (String cat : categories = entry.getValue()) {
                for (String scat : scategories) {
                    if (!scat.equalsIgnoreCase(cat)) continue;
                    sections.add(section);
                }
            }
        }
        if (sections.size() == 0) {
            for (Map.Entry<String, String[]> entry : mappings) {
                section = entry.getKey();
                for (String cat : categories = entry.getValue()) {
                    Set stopics = ni.getTopics();
                    for (String topic : stopics) {
                        if (!topic.contains(cat)) continue;
                        sections.add(section);
                    }
                }
            }
        }
        if (sections.size() == 0 && useModel) {
            String line = SVMTool.buildSVMLine(ni);
            String label = SVMClassifier.classify(line).getLabel();
            System.out.printf("SVM: %s -> %s%n", ni.getUrl(), label);
            sections.add(label);
        }
        ni.addSections(sections);
    }

    public static final void assignSections(NewsItem ni, boolean useModel) {
        instance.doAssignSections(ni, useModel);
    }

    public static void main(String[] args) {
        String slug = "www-publico-pt_2015_05_26_1275398276_duas-dezenas-de-policias-mortos-no-quenia-pelas-al-shabab";
        SolrQuery squery = new SolrQuery(String.format("Slug:%s", slug));
        squery.setFields(Solr.FIELDS);
        squery.setRows(Integer.valueOf(1));
        QueryResponse rsp = NewsSolrSearch.query(squery);
        SolrDocumentList docs = rsp.getResults();
        NewsItem article = new NewsItemBuilder((SolrDocument)docs.get(0)).get();
        NaiveClassifier.assignSections(article, false);
        System.out.println(article);
    }
}

