/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import pt.sapo.hp24.api.NewsItem;
import pt.sapo.hp24.api.RelatedVideo;
import pt.sapo.hp24.db.tools.NewsItemBuilder;
import pt.sapo.hp24.db.tools.NewsSolrSearch;
import pt.sapo.hp24.db.tools.Solr;
import pt.sapo.hp24.db.tools.VideosSolrSearch;

public class Videos {
    public static final float vid_rel_keywords_min_score = 0.13f;
    public static final float vid_rel_lead_min_score = 0.17f;

    public static List<RelatedVideo> fetchRelatedVideos(NewsItem ni) {
        String tokens = ni.getKeywords();
        boolean withKeywords = true;
        if (StringUtils.isBlank((CharSequence)tokens)) {
            tokens = ni.getLeadText();
            withKeywords = false;
            if (StringUtils.isBlank((CharSequence)tokens)) {
                return Collections.emptyList();
            }
        }
        String categories = StringUtils.join((Iterable)ni.getCategories(), (String)" ") + StringUtils.join((Iterable)ni.getTopics(), (String)" ");
        List<RelatedVideo> lst_vid = Collections.emptyList();
        try {
            lst_vid = Videos.fetchByWords(tokens, categories, 0.13f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (lst_vid.size() > 0) {
            return lst_vid;
        }
        if (withKeywords) {
            tokens = ni.getLeadText();
            return Videos.fetchByWords(tokens, categories, 0.17f);
        }
        return Collections.emptyList();
    }

    private static List<RelatedVideo> fetchByWords(String keywords, String categories, float min_score) {
        List<RelatedVideo> relatedVideos;
        QueryResponse qrsp = VideosSolrSearch.related(keywords + " " + categories);
        if (qrsp.getResults().getNumFound() > 0L && qrsp.getResults().getMaxScore().floatValue() > min_score) {
            relatedVideos = new ArrayList<RelatedVideo>();
            SolrDocumentList srelated = qrsp.getResults();
            for (int i = 0; i < srelated.size(); ++i) {
                SolrDocument sdoc = (SolrDocument)srelated.get(i);
                float score = ((Float)sdoc.getFieldValue("score")).floatValue();
                if (!(score > min_score)) continue;
                String title = (String)sdoc.getFieldValue("Title");
                String userName = (String)sdoc.getFieldValue("UserName");
                String randName = (String)sdoc.getFieldValue("RandName");
                ArrayList xpto = new ArrayList(sdoc.getFieldValues("Interface"));
                if (relatedVideos.size() <= 0 || !relatedVideos.get(0).getTitle().equalsIgnoreCase(title)) {
                    System.out.println("RelatedVideo-> title: " + title + ", id: " + randName + ", keywords: " + keywords + " ,categories: " + categories + ", score: " + score);
                    relatedVideos.add(new RelatedVideo(randName, userName, title, score, xpto));
                    continue;
                }
                break;
            }
        } else {
            relatedVideos = Collections.emptyList();
        }
        return relatedVideos;
    }

    public static void main(String[] args) {
        String slug = "www-dn-pt_2015_01_29_625013851_muro-da-sinagoga-do-porto-ja-esta-a-ser-erguido-com-ajuda-israelita";
        SolrQuery squery = new SolrQuery(String.format("Slug:%s", slug));
        squery.setFields(Solr.FIELDS);
        squery.setRows(Integer.valueOf(1));
        QueryResponse rsp = NewsSolrSearch.query(squery);
        SolrDocumentList docs = rsp.getResults();
        NewsItem article = new NewsItemBuilder((SolrDocument)docs.get(0)).get();
        List<RelatedVideo> lst = Videos.fetchRelatedVideos(article);
        System.out.println("######################################################");
        lst.stream().forEach(System.out::println);
    }
}

