/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;

public class JsonResponseHandler
implements ResponseHandler<Integer> {
    protected static final ObjectMapper mapper = new ObjectMapper();
    private final String jsonPath;
    private final String net;

    public JsonResponseHandler(String net, String jsonPath) {
        this.net = net;
        this.jsonPath = jsonPath;
    }

    public Integer handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                JsonNode rootNode = mapper.readTree(bytes);
                int count = rootNode.at(this.jsonPath).asInt(0);
                return count;
            }
            return 0;
        }
        throw new ClientProtocolException("Unexpected response status from " + this.net + ". Status: " + status);
    }

    public String getNet() {
        return this.net;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }
}

