/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hp24.db.tools;

import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Slug {
    private static final TimeZone timeZone;
    private static final Pattern pattern;
    private static final HashSet<Character> allowed;
    private static final ThreadLocal<SimpleDateFormat> sdf;

    private static final String deAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    private static final String sane(String input) {
        char[] in_chars = input.toCharArray();
        StringBuilder result = new StringBuilder();
        int ix = in_chars.length;
        for (char c : in_chars) {
            --ix;
            if (allowed.contains(Character.valueOf(c))) {
                result.append(c);
                continue;
            }
            if (ix <= 0) continue;
            result.append('-');
        }
        return result.toString();
    }

    public static final String create(String host, String searchSlug, String title, Date pubDate, String url) {
        String shost = StringUtils.replace((String)host, (String)".", (String)"-");
        if (StringUtils.isNotBlank((CharSequence)searchSlug)) {
            return searchSlug;
        }
        String stitle = Slug.sane(Slug.deAccent(title));
        String pdate = pubDate != null ? sdf.get().format(pubDate) : "-";
        return String.format("%s_%s_%s_%s", shost, pdate, Math.abs(url.hashCode()), stitle).toLowerCase();
    }

    public static void main(String[] args) {
        System.out.println(Slug.create("example.com", "", "\u00e7\u00e3o&gl\u00f3ria \u00e9 \u00ecsto?", new Date(), "htttp://example.com/article/xpto"));
    }

    static {
        char[] allowed_chars;
        timeZone = TimeZone.getTimeZone("UTC");
        pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        allowed = new HashSet();
        for (char c : allowed_chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ--".toCharArray()) {
            allowed.add(Character.valueOf(c));
        }
        sdf = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                String pattern = "yyyy_MM_dd";
                SimpleDateFormat _format = new SimpleDateFormat("yyyy_MM_dd");
                _format.setTimeZone(timeZone);
                return _format;
            }
        };
    }
}

