/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hpviagens.api.CanaisAPI;
import pt.sapo.hpviagens.api.Categories;
import pt.sapo.hpviagens.api.MainMenuApiList;
import pt.sapo.hpviagens.api.tripadvisor.TripAdvResp;

public class NewsDb
implements Serializable {
    private static final long serialVersionUID = -3173774769371117459L;
    private static final Logger log = LoggerFactory.getLogger(NewsDb.class);
    private static NewsDb instance = new NewsDb();
    private MainMenuApiList menus;
    private CanaisAPI canais;
    private Map<String, Categories> categoriesBySlug;
    private Map<String, CanaisAPI> partnersBySlug;
    private Map<String, CanaisAPI> especialBySlug;
    private Map<String, CanaisAPI> itemBySlug;
    private Map<String, CanaisAPI> itemByUrl;
    private Map<String, TripAdvResp> itemTravelApiByUrl;
    private Date lastModified = new Date();

    private NewsDb() {
        File adbFile = new File("./news.db");
        if (adbFile.exists()) {
            try (FileInputStream fis = new FileInputStream(adbFile);
                 ObjectInputStream in = new ObjectInputStream(fis);){
                NewsDb ard = (NewsDb)in.readObject();
                this.init(ard.doGetMenus(), ard.doGetCategories(), ard.doGetPartners(), ard.doGetEspecials(), ard.doGetAllItemBySlug(), ard.doGetAllItemByUrl(), ard.doGetAllItemTravelApiByUrl());
            }
            catch (Throwable t) {
                Shutdown.now((Throwable)t);
            }
        } else {
            this.init(new MainMenuApiList(), new HashMap<String, Categories>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, TripAdvResp>());
        }
    }

    private static synchronized void dump(NewsDb adb) {
        File outFile = new File("./news.db.tmp");
        try (FileOutputStream fileOut = new FileOutputStream(outFile);
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            out.writeObject(adb);
            out.close();
            fileOut.close();
            File dstFile = new File("./news.db");
            Files.move(outFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static final void build(MainMenuApiList _menus, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstEspecials, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, TripAdvResp> _lstTripApiByUrl) {
        log.info("build(CanaisApiList menus)");
        NewsDb adb = new NewsDb(_menus, _lstCategories, _lstPartners, _lstEspecials, _lstPagesBySlug, _lstPagesByUrl, _lstTripApiByUrl);
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(InputStream input) {
        log.info("build(InputStream input)");
        try (ObjectInputStream in = new ObjectInputStream(input);){
            NewsDb adb = (NewsDb)in.readObject();
            NewsDb.dump(adb);
            instance = adb;
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public NewsDb(MainMenuApiList _menus, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstEspecials, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, TripAdvResp> _lstTripApiByUrl) {
        this.init(_menus, _lstCategories, _lstPartners, _lstEspecials, _lstPagesBySlug, _lstPagesByUrl, _lstTripApiByUrl);
    }

    private void init(MainMenuApiList _menus, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstEspecials, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, TripAdvResp> _lstTripApiByUrl) {
        this.categoriesBySlug = new HashMap<String, Categories>();
        this.partnersBySlug = new HashMap<String, CanaisAPI>();
        this.especialBySlug = new HashMap<String, CanaisAPI>();
        this.itemBySlug = new HashMap<String, CanaisAPI>();
        this.itemByUrl = new HashMap<String, CanaisAPI>();
        this.itemTravelApiByUrl = new HashMap<String, TripAdvResp>();
        this.menus = _menus;
        this.fillLookupTables(_lstCategories, _lstPartners, _lstEspecials, _lstPagesBySlug, _lstPagesByUrl, _lstTripApiByUrl);
        this.lastModified = new Date();
    }

    private void fillLookupTables(Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstEspecials, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, TripAdvResp> _lstTripApiByUrl) {
        this.categoriesBySlug = _lstCategories;
        this.partnersBySlug = _lstPartners;
        this.especialBySlug = _lstEspecials;
        this.itemBySlug = _lstPagesBySlug;
        this.itemByUrl = _lstPagesByUrl;
        this.itemTravelApiByUrl = _lstTripApiByUrl;
    }

    public static final MainMenuApiList getMenus() {
        return instance.doGetMenus();
    }

    public static final Map<String, Categories> getCategories() {
        return instance.doGetCategories();
    }

    public static final Map<String, CanaisAPI> getPartners() {
        return instance.doGetPartners();
    }

    public static final Map<String, CanaisAPI> getEspecials() {
        return instance.doGetEspecials();
    }

    private MainMenuApiList doGetMenus() {
        return this.menus;
    }

    private Map<String, Categories> doGetCategories() {
        return this.categoriesBySlug;
    }

    private Map<String, CanaisAPI> doGetPartners() {
        return this.partnersBySlug;
    }

    private Map<String, CanaisAPI> doGetEspecials() {
        return this.especialBySlug;
    }

    public static final CanaisAPI getCanais() {
        return instance.doGetCanais();
    }

    private CanaisAPI doGetCanais() {
        return this.canais;
    }

    public static final CanaisAPI getItemByUrl(String url) {
        return instance.doGetItemByUrl(url);
    }

    public static final CanaisAPI getItemBySlug(String slug) {
        return instance.doGetItemBySlug(slug);
    }

    public static final TripAdvResp getItemTravelApiBySlug(String slug) {
        return instance.doGetItemTravelApiByUrl(slug);
    }

    public static final Map<String, CanaisAPI> getAllItemBySlug() {
        return instance.doGetAllItemBySlug();
    }

    public static final Map<String, CanaisAPI> getAllItemByUrl() {
        return instance.doGetAllItemByUrl();
    }

    private Map<String, CanaisAPI> doGetAllItemBySlug() {
        return this.itemBySlug;
    }

    private Map<String, CanaisAPI> doGetAllItemByUrl() {
        return this.itemByUrl;
    }

    private Map<String, TripAdvResp> doGetAllItemTravelApiByUrl() {
        return this.itemTravelApiByUrl;
    }

    private CanaisAPI doGetItemBySlug(String slug) {
        return this.itemBySlug.get(slug);
    }

    private CanaisAPI doGetItemByUrl(String url) {
        return this.itemByUrl.get(url);
    }

    private TripAdvResp doGetItemTravelApiByUrl(String url) {
        return this.itemTravelApiByUrl.get(url);
    }

    public static final Date getLastModified() {
        return instance.doGetLastModified();
    }

    private Date doGetLastModified() {
        return this.lastModified;
    }

    public static Object getArticleBySlug(String slug) {
        return NewsDb.instance.itemBySlug.get(slug);
    }

    public static Object getArticleByUrl(String url) {
        return NewsDb.instance.itemByUrl.get(url);
    }

    public static Object getTravelLocationByUrl(String url) {
        return NewsDb.instance.itemTravelApiByUrl.get(url);
    }

    private void fillLookupTables(List<CanaisAPI> lst) {
        if (lst != null) {
            for (CanaisAPI ci : lst) {
                this.itemBySlug.put(ci.getSlug(), ci);
                this.itemByUrl.put(ci.getUrl(), ci);
            }
        }
    }
}

