/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hpviagens.api.Block;
import pt.sapo.hpviagens.api.CanaisAPI;
import pt.sapo.hpviagens.api.CanaisListAPI;
import pt.sapo.hpviagens.api.MainMenuApiList;
import pt.sapo.hpviagens.api.NewsDb;
import pt.sapo.hpviagens.api.TravelAPI;
import pt.sapo.hpviagens.api.TravelLocationAPI;
import pt.sapo.hpviagens.tools.HttpClient;

public class NewsDbBuilder {
    private static final Logger log = LoggerFactory.getLogger(NewsDbBuilder.class);
    private static HttpClient ht;
    public static List<String> lstSlugs;
    public static List<String> lstTripAdvByUrl;

    public static void main(String[] args) {
        try {
            NewsDbBuilder.build();
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
        finally {
            log.info("End processing.");
            Shutdown.now();
        }
    }

    public static void build() {
        try {
            CanaisAPI _resultCanaisPage;
            HashSet excludeUrls = new HashSet();
            lstSlugs = new ArrayList<String>();
            lstTripAdvByUrl = new ArrayList<String>();
            HashMap<String, CanaisAPI> _lstPagesBySlug = new HashMap<String, CanaisAPI>();
            HashMap<String, CanaisAPI> _lstPagesByUrl = new HashMap<String, CanaisAPI>();
            HashMap<String, TravelLocationAPI> _lstTripAdvByUrl = new HashMap<String, TravelLocationAPI>();
            ht = new HttpClient();
            log.info("GET MainMenuApiList: http://viajar.api.backoffice.canais.staging.sapo.pt/v2/menus/menu-principal?api_key=652bfcdd-a8fe-42b3-bfd7-d5c8b253a24d");
            MainMenuApiList _menus = ht.doHttpGetMainMenuAPI("http://viajar.api.backoffice.canais.staging.sapo.pt/v2/menus/menu-principal?api_key=652bfcdd-a8fe-42b3-bfd7-d5c8b253a24d");
            CanaisListAPI _resultCanaisPages = ht.doHttpGetCanaisListAPI("http://viajar.api.backoffice.canais.staging.sapo.pt/v2/block_pages?api_key=652bfcdd-a8fe-42b3-bfd7-d5c8b253a24d");
            for (CanaisAPI item : _resultCanaisPages.getItems()) {
                log.info("GET BlockPages: http://viajar.api.backoffice.canais.staging.sapo.pt/v2/block_pages/" + item.getSlug() + "?api_key=652bfcdd-a8fe-42b3-bfd7-d5c8b253a24d&metadata=blocks");
                _resultCanaisPage = ht.doHttpGetCanaisAPI("http://viajar.api.backoffice.canais.staging.sapo.pt/v2/block_pages/" + item.getSlug() + "?api_key=652bfcdd-a8fe-42b3-bfd7-d5c8b253a24d&metadata=blocks");
                NewsDbBuilder.getTripAdvLocationId(_resultCanaisPage);
                NewsDbBuilder.getSlugsFromPage(_resultCanaisPage);
                _lstPagesBySlug.put(_resultCanaisPage.getSlug(), _resultCanaisPage);
                _lstPagesByUrl.put(_resultCanaisPage.getUrl(), _resultCanaisPage);
            }
            for (String slug : lstSlugs) {
                log.info("GET Posts: http://viajar.api.backoffice.canais.staging.sapo.pt/v2/any/" + slug + "?api_key=652bfcdd-a8fe-42b3-bfd7-d5c8b253a24d&metadata=partner,location_id,destination_id&expand=partner:partner");
                _resultCanaisPage = ht.doHttpGetCanaisAPI("http://viajar.api.backoffice.canais.staging.sapo.pt/v2/any/" + slug + "?api_key=652bfcdd-a8fe-42b3-bfd7-d5c8b253a24d&metadata=partner,location_id,destination_id&expand=partner:partner");
                if (_resultCanaisPage.getMetadata().getDestinationId() != null && !_resultCanaisPage.getMetadata().getDestinationId().isEmpty()) {
                    String tripAdvUrl = "http://127.0.0.1:3000/destinations/" + _resultCanaisPage.getMetadata().getDestinationId();
                    TravelAPI _destination = ht.doHttpGetTravelAPI(tripAdvUrl);
                    _resultCanaisPage.getMetadata().setTravelDestination(_destination);
                }
                _lstPagesBySlug.put(slug, _resultCanaisPage);
            }
            for (String tripAdvUrl : lstTripAdvByUrl) {
                String travelLocationApi = "http://127.0.0.1:3000" + tripAdvUrl;
                log.info("GET TravelAdvAPI: " + travelLocationApi);
                TravelLocationAPI _resultTripAdvLocation = ht.doHttpGetTravelLocationAPI(travelLocationApi);
                _lstTripAdvByUrl.put(tripAdvUrl, _resultTripAdvLocation);
            }
            NewsDb.build((MainMenuApiList)_menus, _lstPagesBySlug, _lstPagesByUrl, _lstTripAdvByUrl);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static void getTripAdvLocationId(CanaisAPI page) {
        for (Block block : page.getBlocks()) {
            if (block.getAttributes().getHighlights() == null) continue;
            for (CanaisAPI highlights : block.getAttributes().getHighlights()) {
                String location;
                if (!highlights.getMetadata().getHighlightedPost().getType().equals("hotel") && !highlights.getMetadata().getHighlightedPost().getType().equals("attraction") && !highlights.getMetadata().getHighlightedPost().getType().equals("restaurant") || highlights.getMetadata().getHighlightedPost().getMetadata().getLocationId() == null || lstTripAdvByUrl.contains(location = "/locations/hotels/" + highlights.getMetadata().getHighlightedPost().getMetadata().getLocationId())) continue;
                lstTripAdvByUrl.add(location);
            }
        }
    }

    public static void getSlugsFromPage(CanaisAPI page) {
        if (page.getBlocks() != null && page.getBlocks().size() > 0) {
            for (Block block : page.getBlocks()) {
                if (block.getAttributes().getHighlights() == null || block.getAttributes().getHighlights().size() <= 0) continue;
                for (CanaisAPI highlight : block.getAttributes().getHighlights()) {
                    if (lstSlugs.contains(highlight.getMetadata().getHighlightedPost().getSlug())) continue;
                    lstSlugs.add(highlight.getMetadata().getHighlightedPost().getSlug());
                }
            }
        }
    }
}

