/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hpviagens.db.App;
import pt.sapo.hpviagens.db.Constants;
import pt.sapo.hpviagens.db.MsgIndexer;

public class IndexerConsumer
implements Runnable {
    static final Logger log = LoggerFactory.getLogger(IndexerConsumer.class);
    protected static final ObjectMapper mapper = new ObjectMapper();
    String message;

    public IndexerConsumer(String msg) {
        this.message = msg;
    }

    @Override
    public void run() {
        try {
            MsgIndexer myObject = null;
            myObject = (MsgIndexer)mapper.readValue(this.message, MsgIndexer.class);
            if (myObject.getDomain().equals(Constants.properties.get("server.broker.domain")) && myObject.getMethod().equals("save_post") && myObject.getContent().getStatus().equals("publish")) {
                log.info("############################### NOVO ARTIGO ###############################");
                long start = System.currentTimeMillis();
                log.info("#1Inicio do updatedb");
                App.buildAndUpload();
                log.info("#1Fim do updatedb");
                log.info("Total time: {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
            }
        }
        catch (IOException e) {
            log.error("error: {}", (Object)e.toString());
            e.printStackTrace();
        }
    }
}

