/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hpviagens.api.Block;
import pt.sapo.hpviagens.api.CanaisAPI;
import pt.sapo.hpviagens.api.CanaisListAPI;
import pt.sapo.hpviagens.api.Categories;
import pt.sapo.hpviagens.api.CategoriesList;
import pt.sapo.hpviagens.api.MainMenuApiList;
import pt.sapo.hpviagens.api.NewsDb;
import pt.sapo.hpviagens.api.tripadvisor.TripAdvResp;
import pt.sapo.hpviagens.db.Constants;
import pt.sapo.hpviagens.tools.HttpClient;

public class NewsDbBuilder {
    private static final Logger log = LoggerFactory.getLogger(NewsDbBuilder.class);
    private static HttpClient ht;
    public static List<String> lstSlugs;
    public static List<String> lstTripApiByUrl;
    static final boolean TRAVEL_ON;
    static final String CANAIS_API_URL;
    static final String CANAIS_API_KEY;
    static final String TRAVEL_API_URL;

    public static void main(String[] args) {
        try {
            NewsDbBuilder.build();
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
        finally {
            log.info("End processing.");
            Shutdown.now();
        }
    }

    public static void build() {
        try {
            CanaisAPI _resultCanaisPage;
            lstSlugs = new ArrayList<String>();
            lstTripApiByUrl = new ArrayList<String>();
            Map<Object, Object> _lstCategories = new HashMap();
            HashMap<String, CanaisAPI> _lstPartners = new HashMap<String, CanaisAPI>();
            HashMap<String, CanaisAPI> _lstEspecials = new HashMap<String, CanaisAPI>();
            HashMap<String, CanaisAPI> _lstPagesBySlug = new HashMap<String, CanaisAPI>();
            HashMap<String, CanaisAPI> _lstPagesByUrl = new HashMap<String, CanaisAPI>();
            HashMap<String, TripAdvResp> _lstTripApiByUrl = new HashMap<String, TripAdvResp>();
            String _urlGetMainMenu = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getmainmenu.path"), CANAIS_API_KEY);
            String _urlGetCategories = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getcategories.path"), CANAIS_API_KEY);
            String _urlGetBlockPages = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getblockpages.path"), CANAIS_API_KEY);
            String _urlGetEspecialPages = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getdossier.path"), CANAIS_API_KEY);
            String _urlGetBlockPage = new String();
            String _urlGetArtEspecial = new String();
            String _urlGetPage = new String();
            String _urlGetTripDest = new String();
            String _urlGetTripLocal = new String();
            String _urlGetGallery = new String();
            String _urlGetPartners = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getpartners.path"), CANAIS_API_KEY);
            HashMap<String, CanaisListAPI> _lstPartnersLastArticles = new HashMap<String, CanaisListAPI>();
            ht = new HttpClient();
            log.info("GET CANAIS_API: " + _urlGetMainMenu);
            MainMenuApiList _menus = ht.doHttpGetMainMenuAPI(_urlGetMainMenu);
            log.info("GET CANAIS_API: " + _urlGetCategories);
            CategoriesList _categories = ht.doHttpGetCategoriesAPI(_urlGetCategories);
            _lstCategories = NewsDbBuilder.getCategoriesToList(_categories);
            log.info("GET CANAIS_API: " + _urlGetPartners);
            CanaisListAPI _resultLstPartners = ht.doHttpGetCanaisListAPI(_urlGetPartners);
            for (Object item : _resultLstPartners.getItems()) {
                _lstPartners.put(item.getSlug(), (CanaisAPI)item);
            }
            log.info("GET CANAIS_API: " + _urlGetEspecialPages);
            CanaisListAPI _resultLstEspecial = ht.doHttpGetCanaisListAPI(_urlGetEspecialPages);
            for (CanaisAPI item : _resultLstEspecial.getItems()) {
                _urlGetArtEspecial = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getarticlesfromdossier.path"), CANAIS_API_KEY, item.getId(), CANAIS_API_KEY);
                log.info("GET CANAIS_API: " + _urlGetArtEspecial);
                CanaisListAPI _lstSolrArticles = ht.doHttpGetCanaisListAPI(_urlGetArtEspecial);
                item.getMetadata().setFullEspecialArticles(_lstSolrArticles.getItems());
                for (Object post : _lstSolrArticles.getItems()) {
                    lstSlugs.add(post.getSlug());
                }
                _lstEspecials.put(item.getUrl(), item);
            }
            log.info("GET CANAIS_API: " + _urlGetBlockPages);
            CanaisListAPI _resultCanaisPages = ht.doHttpGetCanaisListAPI(_urlGetBlockPages);
            for (CanaisAPI item : _resultCanaisPages.getItems()) {
                _urlGetBlockPage = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getblockpage.path"), item.getSlug(), CANAIS_API_KEY);
                log.info("GET CANAIS_API: " + _urlGetBlockPage);
                _resultCanaisPage = ht.doHttpGetCanaisAPI(_urlGetBlockPage);
                for (Block block : _resultCanaisPage.getBlocks()) {
                    if (!block.getType().equals("partners_highlights")) continue;
                    for (CanaisAPI highlight : block.getAttributes().getHighlights()) {
                        if (StringUtils.isEmpty((CharSequence)highlight.getMetadata().getHighlightedPost().getMetadata().getPartnerId())) continue;
                        for (CanaisAPI _item : _resultLstPartners.getItems()) {
                            if (!_item.getId().equals(highlight.getMetadata().getHighlightedPost().getMetadata().getPartnerId())) continue;
                            highlight.getMetadata().getHighlightedPost().getMetadata().setFullPartner(_item);
                        }
                    }
                }
                NewsDbBuilder.getTripAdvLocationId(_resultCanaisPage);
                NewsDbBuilder.getTripAdvDestinationId(_resultCanaisPage);
                NewsDbBuilder.getSlugsFromPage(_resultCanaisPage);
                _lstPagesBySlug.put(_resultCanaisPage.getSlug(), _resultCanaisPage);
                _lstPagesByUrl.put(_resultCanaisPage.getUrl(), _resultCanaisPage);
            }
            for (String slug : lstSlugs) {
                _urlGetPage = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getarticle.path"), slug, CANAIS_API_KEY);
                log.info("GET CANAIS_API: " + _urlGetPage);
                _resultCanaisPage = ht.doHttpGetCanaisAPI(_urlGetPage);
                if (_resultCanaisPage == null) continue;
                if (!StringUtils.isEmpty((CharSequence)_resultCanaisPage.getMetadata().getDestinationId()) && TRAVEL_ON) {
                    _urlGetTripDest = TRAVEL_API_URL + Constants.properties.getProperty("api.travel.dest.path") + _resultCanaisPage.getMetadata().getDestinationId();
                    log.info("GET TRAVEL_API: " + _urlGetTripDest);
                    TripAdvResp _travelDest = ht.doHttpGetTripAdvAPI(_urlGetTripDest);
                    _resultCanaisPage.getMetadata().setTravelApiDestination(_travelDest);
                }
                if (!StringUtils.isEmpty((CharSequence)_resultCanaisPage.getMetadata().getPhotoGalleryId())) {
                    _urlGetGallery = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getgallery.path"), _resultCanaisPage.getMetadata().getPhotoGalleryId(), CANAIS_API_KEY);
                    log.info("GET CANAIS_API: " + _urlGetGallery);
                    CanaisAPI _resultGallery = ht.doHttpGetCanaisAPI(_urlGetGallery);
                    _resultCanaisPage.getMetadata().setFullPhotoGallery(_resultGallery);
                }
                if (!StringUtils.isEmpty((CharSequence)_resultCanaisPage.getMetadata().getPartnerId())) {
                    for (CanaisAPI item : _resultLstPartners.getItems()) {
                        if (!item.getId().equals(_resultCanaisPage.getMetadata().getPartnerId())) continue;
                        _resultCanaisPage.getMetadata().setFullPartner(item);
                    }
                    ArrayList<CanaisAPI> _lstPartnerLast = new ArrayList<CanaisAPI>();
                    String _urlGetPartnerLast = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getlastpartner.path") + Constants.properties.getProperty("api.canais.pagesize.lastpartner"), CANAIS_API_KEY, _resultCanaisPage.getMetadata().getPartnerId());
                    CanaisListAPI _resultCanaisPartnerLastSolr = (CanaisListAPI)_lstPartnersLastArticles.get(_urlGetPartnerLast);
                    if (_resultCanaisPartnerLastSolr == null) {
                        log.info("GET LAST PARTNER CANAIS_API: " + _urlGetPartnerLast);
                        _resultCanaisPartnerLastSolr = ht.doHttpGetCanaisListAPI(_urlGetPartnerLast);
                        _lstPartnersLastArticles.put(_urlGetPartnerLast, _resultCanaisPartnerLastSolr);
                    }
                    if (_resultCanaisPartnerLastSolr.getItemsPerPage() > 0) {
                        for (CanaisAPI item : _resultCanaisPartnerLastSolr.getItems()) {
                            _lstPartnerLast.add(item);
                        }
                    }
                    _resultCanaisPage.getMetadata().setFullPartenerLastArticles(_lstPartnerLast);
                }
                ArrayList<CanaisAPI> _lstRelated = new ArrayList<CanaisAPI>();
                String _urlGetRelated = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getrelated.path") + Constants.properties.getProperty("api.canais.pagesize.related"), CANAIS_API_KEY, _resultCanaisPage.getSlug(), _resultCanaisPage.getId());
                log.info("GET RELATED CANAIS_API: " + _urlGetRelated);
                CanaisListAPI _resultCanaisRelatedSolr = ht.doHttpGetCanaisListAPI(_urlGetRelated);
                if (_resultCanaisRelatedSolr.getItemsPerPage() > 0) {
                    for (CanaisAPI item : _resultCanaisRelatedSolr.getItems()) {
                        _lstRelated.add(item);
                    }
                }
                if (_resultCanaisPage.getMetadata().getRelatedArticlesIds() != null && _resultCanaisPage.getMetadata().getRelatedArticlesIds().size() > 0) {
                    int count = 0;
                    for (String postId : _resultCanaisPage.getMetadata().getRelatedArticlesIds()) {
                        _urlGetPage = CANAIS_API_URL + String.format(Constants.properties.getProperty("api.canais.getarticlebyid.path"), postId, CANAIS_API_KEY);
                        log.info("GET CANAIS_API: " + _urlGetPage);
                        CanaisAPI _resultCanaisPageRelated = ht.doHttpGetCanaisAPI(_urlGetPage);
                        _lstRelated.add(0, _resultCanaisPageRelated);
                        _lstRelated.remove(_lstRelated.size() - ++count);
                    }
                }
                if (_lstRelated.size() > 0) {
                    _resultCanaisPage.getMetadata().setFullRelatedArticles(_lstRelated);
                }
                _lstPagesBySlug.put(slug, _resultCanaisPage);
            }
            if (TRAVEL_ON) {
                for (String tripAdvUrl : lstTripApiByUrl) {
                    _urlGetTripLocal = TRAVEL_API_URL + tripAdvUrl;
                    log.info("GET TRAVEL_API: " + _urlGetTripLocal);
                    TripAdvResp _travelLocal = ht.doHttpGetTripAdvAPI(_urlGetTripLocal);
                    _lstTripApiByUrl.put(tripAdvUrl, _travelLocal);
                }
            }
            NewsDb.build((MainMenuApiList)_menus, _lstCategories, _lstPartners, _lstEspecials, _lstPagesBySlug, _lstPagesByUrl, _lstTripApiByUrl);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static Map<String, Categories> getCategoriesToList(CategoriesList _categories) {
        Map<String, Categories> _listCategories = new HashMap<String, Categories>();
        for (Categories _category : _categories) {
            _category.setClassSlug(_category.getSlug());
            _listCategories.put(_category.getSlug(), _category);
            if (_category.getChildren().size() <= 0) continue;
            _listCategories = NewsDbBuilder.getCategoriesFromChildren(_listCategories, _category, _category.getSlug());
        }
        return _listCategories;
    }

    public static Map<String, Categories> getCategoriesFromChildren(Map<String, Categories> _listCategories, Categories _category, String classSlug) {
        for (Categories _cat : _category.getChildren()) {
            _cat.setClassSlug(classSlug);
            _listCategories.put(_cat.getSlug(), _cat);
            if (_category.getChildren().size() <= 0) continue;
            _listCategories = NewsDbBuilder.getCategoriesFromChildren(_listCategories, _cat, _cat.getSlug());
        }
        return _listCategories;
    }

    public static void getTripAdvLocationId(CanaisAPI page) {
        for (Block block : page.getBlocks()) {
            if (block.getAttributes().getHighlights() == null) continue;
            for (CanaisAPI highlights : block.getAttributes().getHighlights()) {
                String location;
                if (!highlights.getMetadata().getHighlightedPost().getType().equals("restaurant") && !highlights.getMetadata().getHighlightedPost().getType().equals("attraction") && !highlights.getMetadata().getHighlightedPost().getType().equals("hotel") || highlights.getMetadata().getHighlightedPost().getMetadata().getLocationId() == null || lstTripApiByUrl.contains(location = Constants.properties.getProperty("api.travel.local.path") + highlights.getMetadata().getHighlightedPost().getMetadata().getLocationId())) continue;
                lstTripApiByUrl.add(location);
            }
        }
    }

    public static void getTripAdvDestinationId(CanaisAPI page) {
        for (Block block : page.getBlocks()) {
            if (block.getAttributes().getHighlights() == null) continue;
            for (CanaisAPI highlights : block.getAttributes().getHighlights()) {
                String destination;
                if (!highlights.getMetadata().getHighlightedPost().getType().equals("destination") || highlights.getMetadata().getHighlightedPost().getMetadata().getDestinationId() == null || lstTripApiByUrl.contains(destination = Constants.properties.getProperty("api.travel.dest.path") + highlights.getMetadata().getHighlightedPost().getMetadata().getDestinationId())) continue;
                lstTripApiByUrl.add(destination);
            }
        }
    }

    public static void getSlugsFromPage(CanaisAPI page) {
        if (page.getBlocks() != null && page.getBlocks().size() > 0) {
            for (Block block : page.getBlocks()) {
                if (block.getAttributes().getHighlights() == null || block.getAttributes().getHighlights().size() <= 0) continue;
                for (CanaisAPI highlight : block.getAttributes().getHighlights()) {
                    if (!highlight.getMetadata().getHighlightedPost().getType().equals("post") || lstSlugs.contains(highlight.getMetadata().getHighlightedPost().getSlug())) continue;
                    lstSlugs.add(highlight.getMetadata().getHighlightedPost().getSlug());
                }
            }
        }
    }

    private static Categories createCategory(String slug) {
        Categories _category = new Categories();
        _category.setSlug(slug);
        return _category;
    }

    static {
        TRAVEL_ON = Constants.properties.getProperty("tripadv.on").equals("true");
        CANAIS_API_URL = Constants.properties.getProperty("api.canais.proto") + Constants.properties.getProperty("api.canais.host");
        CANAIS_API_KEY = Constants.properties.getProperty("api.canais.key");
        TRAVEL_API_URL = Constants.properties.getProperty("api.travel.proto") + Constants.properties.getProperty("api.travel.host");
    }
}

