/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.db.tools;

import java.io.File;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hpviagens.db.tools.AcceptResponseHandler;

public class UploadTo {
    private static Logger log = LoggerFactory.getLogger(UploadTo.class);
    private static final UploadTo instance = new UploadTo();
    private CloseableHttpClient httpclient;

    private UploadTo() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(2);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(3000).setConnectTimeout(3000).build();
        this.httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    private void doHttpPost(String api_url, byte[] body) {
        HttpPost post = new HttpPost(api_url);
        ByteArrayEntity json = new ByteArrayEntity(body, ContentType.create((String)"application/octet-stream"));
        post.setEntity((HttpEntity)json);
        this.doHttpRequest((HttpRequestBase)post, new AcceptResponseHandler());
    }

    private void doHttpRequest(HttpRequestBase httpget, AcceptResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)rsp_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("%s%n", r.getMessage()));
        }
    }

    public static void endpoint(String endpoint, byte[] body) {
        log.info("Upload to: {}", (Object)endpoint);
        instance.doHttpPost(endpoint, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int chunked(String url, File file) throws Exception {
        int code = 0;
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(url);
            FileEntity entity = new FileEntity(file, "binary/octet-stream");
            entity.setChunked(true);
            httppost.setEntity((HttpEntity)entity);
            System.out.println("Executing request: " + httppost.getRequestLine());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                System.out.println("----------------------------------------");
                System.out.println(response.getStatusLine());
                EntityUtils.consume((HttpEntity)response.getEntity());
                code = response.getStatusLine().getStatusCode();
            }
        }
        return code;
    }
}

