/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.concurrent.CustomExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.NetAction;
import pt.sapo.hpviagens.api.NewsDb;
import pt.sapo.hpviagens.api.tripadvisor.TripAdvResp;
import pt.sapo.hpviagens.db.Broker;
import pt.sapo.hpviagens.db.Constants;
import pt.sapo.hpviagens.db.NewsDbBuilder;
import pt.sapo.hpviagens.db.tools.UploadTo;
import pt.sapo.hpviagens.tools.HttpClient;

public class App {
    private static Logger log = LoggerFactory.getLogger(App.class);
    private static final ScheduledExecutorService shed_exec = CustomExecutors.newScheduledThreadPool((int)1, (String)"sched-exec");
    private static Broker broker = new Broker();
    static List<String> frontends = new ArrayList<String>();
    static final String environment;
    public static Object lock_1;
    public static Object lock_2;
    private static final String QUEUE_DB;

    public static void main(String[] args) {
        Runnable db_builder = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                log.info("#1Inicio do updatedb");
                App.buildAndUpload();
                log.info("#1Fim do updatedb");
                log.info("Total time: {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
            }
        };
        try {
            broker.consume(NetAction.DestinationType.TOPIC, QUEUE_DB);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Runnable create_cache = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                log.info("#1Inicio do pre-cache destinations");
                App.populateCache();
                log.info("#1Fim do pre-cache destinations");
                log.info("Total time: {}s", (Object)((System.currentTimeMillis() - start) / 1000L));
            }
        };
        shed_exec.scheduleWithFixedDelay(create_cache, 0L, 15L, TimeUnit.DAYS);
        shed_exec.scheduleWithFixedDelay(db_builder, 0L, 2L, TimeUnit.HOURS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildAndUpload() {
        File toUpload = null;
        try {
            Iterator<String> iterator = lock_1;
            synchronized (iterator) {
                NewsDbBuilder.build();
                Path path = Paths.get("./news.db", new String[0]);
                byte[] data = Files.readAllBytes(path);
                NewsDb.build((InputStream)new FileInputStream("./news.db"));
                toUpload = new File(path.toUri());
            }
            block7: for (String host : frontends) {
                for (int i = 3; i > 0; --i) {
                    try {
                        if (UploadTo.chunked(String.format("http://%s/updatedb", host), toUpload) != 200) continue;
                        continue block7;
                    }
                    catch (Throwable t) {
                        log.error(t.toString());
                        log.error("Sleeping {} milliseconds", (Object)(3000 - 1000 / i));
                        Thread.sleep(3000 - 1000 / i);
                    }
                }
            }
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateCache() {
        try {
            Object object = lock_2;
            synchronized (object) {
                try (BufferedReader br = new BufferedReader(new FileReader("./destinations.txt"));){
                    StringBuilder sb = new StringBuilder();
                    String line = br.readLine();
                    HttpClient ht = new HttpClient();
                    while (line != null) {
                        sb.append(line);
                        sb.append(System.lineSeparator());
                        line = br.readLine();
                        String _urlGetTripLocal = Constants.properties.getProperty("api.travel.proto") + Constants.properties.getProperty("api.travel.host") + "/destinations/" + line;
                        log.info("GET TRAVEL_API: " + _urlGetTripLocal);
                        TripAdvResp tripAdvResp = ht.doHttpGetTripAdvAPI(_urlGetTripLocal);
                    }
                }
            }
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(r.getMessage(), r);
        }
    }

    /*
     * Exception decompiling
     */
    public static synchronized NewsDb getNewsDb() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        lock_1 = new int[1];
        lock_2 = new int[1];
        QUEUE_DB = Constants.properties.getProperty("server.broker.topic");
        environment = System.getProperty("environment", "staging");
        System.out.println("loading settings for " + environment);
        String[] _servers = Constants.properties.getProperty("server.frontends.tosendnewsdb").split(";");
        for (int i = 0; i < _servers.length; ++i) {
            System.out.println("AddServer " + _servers[i]);
            frontends.add(_servers[i]);
        }
    }
}

