/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.db;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.NotificationListenerAdapter;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetNotification;
import pt.sapo.hpviagens.db.CacherConsumer;
import pt.sapo.hpviagens.db.IndexerConsumer;

public class Broker {
    static final Logger log = LoggerFactory.getLogger(Broker.class);
    private static final ExecutorService executor = Executors.newFixedThreadPool(5);
    private static final String BROKER_HOST = "broker.bk.sapo.pt";
    private static final Integer BROKER_PORT = 3323;
    private BrokerClient bClient;

    public Broker() {
        this.bClient = new BrokerClient(BROKER_HOST, BROKER_PORT.intValue());
        this.bClient.connect();
    }

    public Broker(String brokerHost, int brokerPort) throws Throwable {
        this.bClient = new BrokerClient(brokerHost, brokerPort);
        this.bClient.connect();
    }

    public void consume(NetAction.DestinationType destinationType, String destination) throws Throwable {
        this.bClient.subscribe(destination, destinationType, (BrokerListener)new NotificationListenerAdapter(){

            public boolean onMessage(NetNotification notification, HostInfo host) {
                try {
                    String message = new String(notification.getMessage().getPayload(), "UTF-8");
                    log.info("Received a message: {}", (Object)message);
                    executor.execute(new IndexerConsumer(message));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
    }

    public void consumeWarmerCache(NetAction.DestinationType destinationType, String destination) throws Throwable {
        this.bClient.subscribe(destination, destinationType, (BrokerListener)new NotificationListenerAdapter(){

            public boolean onMessage(NetNotification notification, HostInfo host) {
                try {
                    String message = new String(notification.getMessage().getPayload(), "UTF-8");
                    executor.execute(new CacherConsumer(message));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
    }

    public void publish(NetAction.DestinationType destinationType, String destination, String message) {
        try {
            log.debug("Producer generating message.");
            this.bClient.publish(message, destination, destinationType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

