/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BaseBrokerClient;
import pt.com.broker.client.BrokerProtocolHandler;
import pt.com.broker.client.HostInfo;
import pt.com.broker.client.NetworkConnector;
import pt.com.broker.types.NetProtocolType;

public class BrokerClient
extends BaseBrokerClient {
    private static final Logger log = LoggerFactory.getLogger(BrokerClient.class);

    public BrokerClient(String host, int portNumber) throws Throwable {
        super(host, portNumber, 15000, 0);
        this.init();
    }

    public BrokerClient(String host, int portNumber, int retriest) throws Throwable {
        super(host, portNumber, 15000, 0);
        this.setNumberOfTries(retriest);
        this.init();
    }

    public BrokerClient(String host, int portNumber, int retries, int connectTimeout, int readTimeout) throws Throwable {
        super(host, portNumber, connectTimeout, readTimeout);
        this.setNumberOfTries(retries);
        this.init();
    }

    public BrokerClient(String host, int portNumber, String appName, int connectTimeout, int readTimeout) throws Throwable {
        super(host, portNumber, connectTimeout, readTimeout, appName);
        this.init();
    }

    public BrokerClient(String host, int portNumber, String appName) throws Throwable {
        super(host, portNumber, 15000, 0, appName);
        this.init();
    }

    public BrokerClient(String host, int portNumber, String appName, NetProtocolType ptype, int connectTimeout, int readTimeout) throws Throwable {
        super(host, portNumber, connectTimeout, readTimeout, appName, ptype);
        this.init();
    }

    public BrokerClient(String host, int portNumber, String appName, NetProtocolType ptype) throws Throwable {
        super(host, portNumber, 15000, 0, appName, ptype);
        this.init();
    }

    public BrokerClient(Collection<HostInfo> hosts) throws Throwable {
        super(hosts);
        this.init();
    }

    public BrokerClient(Collection<HostInfo> hosts, String appName) throws Throwable {
        super(hosts, appName);
        this.init();
    }

    public BrokerClient(Collection<HostInfo> hosts, String appName, NetProtocolType ptype) throws Throwable {
        super(hosts, appName, ptype);
        this.init();
    }

    @Override
    protected BrokerProtocolHandler getBrokerProtocolHandler() throws Throwable {
        NetworkConnector networkConnector = new NetworkConnector(this.getHostInfo());
        BrokerProtocolHandler brokerProtocolHandler = new BrokerProtocolHandler(this, this.getProtocolType(), networkConnector, this.isOldFramming());
        networkConnector.setProtocolHandler(brokerProtocolHandler);
        return brokerProtocolHandler;
    }

    public String toString() {
        return String.format("BrokerClient [HostInfo:%s]", this.getHostInfo());
    }
}

