/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.Shutdown;
import org.caudexorigo.concurrent.Sleep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.BaseBrokerClient;
import pt.com.broker.client.BaseNetworkConnector;
import pt.com.broker.client.HostInfo;
import pt.com.broker.client.SslBrokerClient;
import pt.com.broker.client.messaging.PendingAcceptRequestsManager;
import pt.com.broker.client.net.ProtocolHandler;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetAccepted;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetNotification;
import pt.com.broker.types.NetProtocolType;

public class BrokerProtocolHandler
extends ProtocolHandler<NetMessage> {
    private static final Logger log = LoggerFactory.getLogger(BrokerProtocolHandler.class);
    private final BaseBrokerClient brokerClient;
    long connectionVersion = 0L;
    private final BaseNetworkConnector connector;
    private BindingSerializer serializer;
    private short proto_type = 1;
    private HostInfo hostInfo = null;
    private final boolean usingNewFramming;
    public static final String PollTimeoutErrorMessageCode = NetFault.PollTimeoutErrorMessage.getAction().getFaultMessage().getCode();
    public static final String NoMessageInQueueErrorMessageCode = NetFault.NoMessageInQueueErrorMessage.getAction().getFaultMessage().getCode();
    public static final NetMessage TimeoutUnblockNotification = new NetMessage(new NetAction(NetAction.ActionType.FAULT));
    public static final NetMessage NoMessageUnblockNotification = new NetMessage(new NetAction(NetAction.ActionType.FAULT));

    public BrokerProtocolHandler(BaseBrokerClient brokerClient, NetProtocolType ptype, BaseNetworkConnector connector, boolean usingOldFramming) throws UnknownHostException, IOException, Throwable {
        this.brokerClient = brokerClient;
        this.connector = connector;
        this.usingNewFramming = !usingOldFramming;
        this.setHostInfo(brokerClient.getHostInfo());
        try {
            connector.connect();
        }
        catch (Throwable error) {
            Throwable rootCause = ErrorAnalyser.findRootCause((Throwable)error);
            if (rootCause instanceof IOException) {
                this.onIOFailure(connector.getConnectionVersion());
            }
            this.onError(error);
        }
        try {
            if (ptype == null) {
                ptype = NetProtocolType.PROTOCOL_BUFFER;
            }
            switch (ptype) {
                case SOAP: {
                    this.proto_type = 0;
                    this.serializer = (BindingSerializer)Class.forName("pt.com.broker.codec.xml.SoapBindingSerializer").newInstance();
                    break;
                }
                case PROTOCOL_BUFFER: {
                    this.proto_type = 1;
                    this.serializer = (BindingSerializer)Class.forName("pt.com.broker.codec.protobuf.ProtoBufBindingSerializer").newInstance();
                    break;
                }
                case THRIFT: {
                    this.proto_type = (short)2;
                    this.serializer = (BindingSerializer)Class.forName("pt.com.broker.codec.thrift.ThriftBindingSerializer").newInstance();
                    break;
                }
                case JSON: {
                    this.proto_type = (short)3;
                    this.serializer = (BindingSerializer)Class.forName("pt.com.broker.codec.protobuf.JsonCodecForProtoBuf").newInstance();
                    break;
                }
                case SOAP_v0: {
                    this.proto_type = 0;
                    this.serializer = (BindingSerializer)Class.forName("pt.com.broker.codec.xml.SoapBindingSerializer").newInstance();
                    break;
                }
                default: {
                    throw new Exception("Invalid Protocol Type: " + ptype);
                }
            }
        }
        catch (Throwable t) {
            log.error("Put the binding implentation of your choice in the classpath and try again", t);
            Shutdown.now();
        }
        brokerClient.setState(BaseBrokerClient.BrokerClientState.OK);
    }

    @Override
    public BaseNetworkConnector getConnector() {
        return this.connector;
    }

    @Override
    public void onConnectionClose() {
        log.debug("Connection Closed");
    }

    @Override
    public void onConnectionOpen() {
        if (this.closed.get()) {
            return;
        }
        log.debug("Connection Opened");
        try {
            this.brokerClient.sendSubscriptions();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
    }

    @Override
    protected synchronized void onIOFailure(long connectionVersion) {
        if (connectionVersion == this.connectionVersion) {
            log.warn("onIoFailure -  connectionVersion: '{}'", (Object)connectionVersion);
            this.brokerClient.setState(BaseBrokerClient.BrokerClientState.FAIL);
            int count = 0;
            while (true) {
                try {
                    SslBrokerClient sslClient;
                    this.connector.close();
                    this.brokerClient.setState(BaseBrokerClient.BrokerClientState.CONNECT);
                    long newConnectionVersion = ++this.connectionVersion;
                    this.connector.connect(this.getHostInfo(), newConnectionVersion);
                    log.info("Connection re-established with " + this.getHostInfo().getHostname() + ":" + this.getHostInfo().getPort());
                    this.brokerClient.setState(BaseBrokerClient.BrokerClientState.OK);
                    if (this.readerStarded) {
                        this.start();
                    }
                    if (this.brokerClient instanceof SslBrokerClient && (sslClient = (SslBrokerClient)this.brokerClient).isAuthenticationRequired()) {
                        sslClient.authenticateClient();
                    }
                    this.onConnectionOpen();
                    this.notifyAll();
                    return;
                }
                catch (Throwable t) {
                    log.error("Failed to reconnect to agent " + this.getHostInfo().getHostname() + ":" + this.getHostInfo().getPort());
                    if (this.getNumberOfTries() == 0) {
                        throw new RuntimeException(t);
                    }
                    Sleep.time((long)(++count * 500));
                    this.setHostInfo(this.brokerClient.getHostInfo());
                    if (count != this.getNumberOfTries()) continue;
                    this.brokerClient.setState(BaseBrokerClient.BrokerClientState.CLOSE);
                    this.notifyAll();
                    this.onError(new Exception("Unable to reconnect after " + this.getNumberOfTries() + " tries!"));
                }
                break;
            }
        }
    }

    @Override
    public void onError(Throwable error) {
        this.brokerClient.getErrorListener().onError(error);
    }

    @Override
    protected void handleReceivedMessage(NetMessage message) {
        NetAction action = message.getAction();
        message.getAction();
        switch (action.getActionType()) {
            case NOTIFICATION: {
                boolean received;
                NetNotification notification = action.getNotificationMessage();
                notification.setHeaders(message.getHeaders());
                if (!notification.getDestinationType().equals((Object)NetAction.DestinationType.TOPIC) && (received = this.brokerClient.offerPollResponse(notification.getSubscription(), message))) {
                    return;
                }
                this.brokerClient.notifyListener(notification);
                break;
            }
            case PONG: {
                try {
                    this.brokerClient.feedStatusConsumer(action.getPongMessage());
                }
                catch (Throwable e) {
                    this.brokerClient.getErrorListener().onError(e);
                }
                break;
            }
            case FAULT: {
                NetFault fault = action.getFaultMessage();
                fault.setHeaders(message.getHeaders());
                if (fault.getCode().equals(PollTimeoutErrorMessageCode) || fault.getCode().equals(NoMessageInQueueErrorMessageCode)) {
                    String destination = fault.getDetail();
                    if (fault.getCode().equals(PollTimeoutErrorMessageCode) && this.brokerClient.offerPollResponse(destination, TimeoutUnblockNotification)) {
                        return;
                    }
                    if (this.brokerClient.offerPollResponse(destination, NoMessageUnblockNotification)) {
                        return;
                    }
                    log.error("A PollTimeout or NoMessageInQueue fault message was received but there wasn't a sync consumer.");
                }
                if (fault.getActionId() != null && PendingAcceptRequestsManager.messageFailed(fault)) {
                    return;
                }
                this.brokerClient.getErrorListener().onFault(fault);
                break;
            }
            case ACCEPTED: {
                NetAccepted accepted = action.getAcceptedMessage();
                PendingAcceptRequestsManager.acceptedMessageReceived(accepted.getActionId());
                break;
            }
            default: {
                throw new RuntimeException("Unexepected ActionType in received message. ActionType: " + action.getActionType());
            }
        }
    }

    @Override
    public NetMessage decode(DataInputStream in) throws IOException {
        if (this.serializer == null) {
            throw new RuntimeException("Received message uses an unknown encoding");
        }
        if (this.usingNewFramming) {
            in.readShort();
            in.readShort();
        }
        int len = in.readInt();
        if (this.serializer == null) {
            throw new RuntimeException("Received message uses an unknown encoding");
        }
        byte[] data = new byte[len];
        in.readFully(data);
        NetMessage message = this.serializer.unmarshal(data);
        return message;
    }

    @Override
    public void encode(NetMessage message, DataOutputStream out) throws IOException {
        byte[] marshaledMsg = this.marshalMessage(message);
        if (this.usingNewFramming) {
            short protocolType = this.proto_type;
            int protocolVersion = 0;
            out.writeShort(protocolType);
            out.writeShort(protocolVersion);
        }
        out.writeInt(marshaledMsg.length);
        out.write(marshaledMsg);
    }

    public byte[] marshalMessage(NetMessage message) throws IOException {
        byte[] marshaledMsg = this.serializer.marshal(message);
        return marshaledMsg;
    }

    @Override
    public void sendMessage(NetMessage message) throws Throwable {
        if (this.brokerClient.getState() == BaseBrokerClient.BrokerClientState.CLOSE) {
            this.onError(new Exception("Message cannot be sent because client was closed"));
            return;
        }
        if (this.brokerClient.getState() == BaseBrokerClient.BrokerClientState.OK || this.brokerClient.getState() == BaseBrokerClient.BrokerClientState.AUTH && message.getAction().getActionType() == NetAction.ActionType.AUTH) {
            super.sendMessage(message);
            return;
        }
        this.onError(new Exception("Message Lost due to failure of agent"));
        log.error("Message Lost due to failure of agent!");
    }

    public BaseBrokerClient getBrokerClient() {
        return this.brokerClient;
    }

    public void setHostInfo(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public void setNumberOfTries(int numberOfTries) {
        this.brokerClient.setNumberOfTries(numberOfTries);
    }

    @Override
    public int getNumberOfTries() {
        return this.brokerClient.getNumberOfTries();
    }
}

