/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client;

public final class HostInfo {
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    private String hostname;
    private int port;
    private final int udpPort;
    private final int connectTimeout;
    private final int readTimeout;

    public HostInfo(String hostname, int port) {
        this(hostname, port, -1, 15000, 0);
    }

    public HostInfo(String hostname, int port, int udpPort) {
        this(hostname, port, udpPort, 15000, 0);
    }

    public HostInfo(String hostname, int port, int udpPort, int connectTimeout, int readTimeout) {
        this.hostname = hostname;
        this.port = port;
        this.udpPort = udpPort;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        HostInfo other = (HostInfo)obj;
        if (!this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.udpPort == other.udpPort;
    }

    public String toString() {
        return String.format("HostInfo [hostname=%s, port=%s, udpPort=%s, connectTimeout=%s, readTimeout=%s]", this.hostname, this.port, this.udpPort, this.connectTimeout, this.readTimeout);
    }
}

